/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import oracle.eclipse.tools.common.services.document.HashingComparator;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentService;

public abstract class TechnologyDocumentServiceAdapterFactory {
    public final IDocumentService createAdapter(Class<? extends IDocumentService> adapterType, IDocument document) {
        return this.doCreateAdapter(adapterType, document);
    }

    protected abstract IDocumentService doCreateAdapter(Class<? extends IDocumentService> var1, IDocument var2);

    public boolean shouldCacheAdapter(Class<? extends IDocumentService> adapterType, Object adapter, IDocument document) {
        return true;
    }

    public HashingComparator getHashingComparator(Class<? extends IDocumentService> adapterType) {
        return new HashingComparator();
    }

    static final class AdapterCacheKey {
        private final Class<? extends IDocumentService> _adapterType;
        private final HashingComparator _comparator;
        private final IDocument _doc;

        public AdapterCacheKey(Class<? extends IDocumentService> adapterType, IDocument doc, HashingComparator comparator) {
            this._adapterType = adapterType;
            this._doc = doc;
            this._comparator = comparator;
        }

        public Class<? extends IDocumentService> getAdapterType() {
            return this._adapterType;
        }

        public IDocument getDocument() {
            return this._doc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AdapterCacheKey) {
                return this._comparator.equals(this._adapterType, ((AdapterCacheKey)obj)._adapterType) && this.getDocument().equals(((AdapterCacheKey)obj).getDocument());
            }
            return false;
        }

        public int hashCode() {
            return this._comparator.hashCode(this._adapterType) + 7 * this._doc.hashCode();
        }
    }
}

