/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.services.document.HashingComparator;
import oracle.eclipse.tools.common.services.document.IDisposable;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentDisposedListener;
import oracle.eclipse.tools.common.services.document.IDocumentService;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.project.technology.TechnologyDocumentServiceAdapterFactory;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractTechnologyExtension
implements ITechnologyExtension {
    private final Project _project;
    private final ITechnologyDescriptor _techDescriptor;
    private final DocumentServiceAdapterCache _documentServiceAdapterCache;

    public AbstractTechnologyExtension(Project project, ITechnologyDescriptor techDescriptor) {
        this._project = project;
        this._techDescriptor = techDescriptor;
        this._documentServiceAdapterCache = new DocumentServiceAdapterCache();
    }

    @Override
    public ITechnologyExtensionIdentifier getTechnologyExtensionIdentifier() {
        if (this._techDescriptor != null) {
            return this._techDescriptor.getTechnologyIdentifier();
        }
        return null;
    }

    protected ITechnologyDescriptor getTechExtDescriptor() {
        return this._techDescriptor;
    }

    @Override
    public final String getId() {
        return this.getTechnologyExtensionIdentifier().getId();
    }

    @Override
    public String getVersion() {
        ITechnologyExtensionIdentifier technologyExtensionIdentifier = this.getTechnologyExtensionIdentifier();
        if (technologyExtensionIdentifier != null) {
            return technologyExtensionIdentifier.getVersion();
        }
        return null;
    }

    @Override
    public final String getBundleId() {
        return this.getTechnologyExtensionIdentifier().getBundleId();
    }

    @Override
    public final Project getProject() {
        return this._project;
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void initExtension() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getSimpleName());
        buf.append(":").append(this._techDescriptor.toString());
        return buf.toString();
    }

    public void close() {
        for (Map.Entry entry : this._documentServiceAdapterCache.entrySet()) {
            IDocumentService value = (IDocumentService)entry.getValue();
            if (!(value instanceof IDisposable)) continue;
            ((IDisposable)((Object)value)).dispose();
        }
        this._documentServiceAdapterCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDocumentService getDocumentService(Class<? extends IDocumentService> serviceType, IDocument forDocument) {
        IDocumentService adapterObj = null;
        TechnologyDocumentServiceAdapterFactory adapterFactory = this.getServiceAdapterFactory();
        if (adapterFactory != null) {
            HashingComparator hashingComparator = adapterFactory.getHashingComparator(serviceType);
            DocumentServiceAdapterCache documentServiceAdapterCache = this._documentServiceAdapterCache;
            synchronized (documentServiceAdapterCache) {
                adapterObj = (IDocumentService)this._documentServiceAdapterCache.get(new TechnologyDocumentServiceAdapterFactory.AdapterCacheKey(serviceType, forDocument, hashingComparator));
                if (adapterObj == null && (adapterObj = adapterFactory.createAdapter(serviceType, forDocument)) != null && adapterFactory.shouldCacheAdapter(serviceType, adapterObj, forDocument)) {
                    this._documentServiceAdapterCache.put(new TechnologyDocumentServiceAdapterFactory.AdapterCacheKey(serviceType, forDocument, hashingComparator), adapterObj);
                }
            }
        }
        return adapterObj;
    }

    protected TechnologyDocumentServiceAdapterFactory getServiceAdapterFactory() {
        return null;
    }

    @Override
    public <T extends IAppService> T getAppService(Class<T> serviceType) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends IDocumentService> List<T> getCachedAdapters(Class<T> serviceType) {
        ArrayList<IDocumentService> result = new ArrayList<IDocumentService>();
        DocumentServiceAdapterCache documentServiceAdapterCache = this._documentServiceAdapterCache;
        synchronized (documentServiceAdapterCache) {
            for (Map.Entry entry : this._documentServiceAdapterCache.entrySet()) {
                if (((TechnologyDocumentServiceAdapterFactory.AdapterCacheKey)entry.getKey()).getAdapterType() != serviceType) continue;
                result.add((IDocumentService)entry.getValue());
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected String getTechnologyVersion() {
        return this.getTechExtDescriptor().getTechnologyIdentifier().getVersion();
    }

    private class DocumentServiceAdapterCache
    extends HashMap<TechnologyDocumentServiceAdapterFactory.AdapterCacheKey, IDocumentService>
    implements IDocumentDisposedListener {
        private static final long serialVersionUID = -1391198201054359220L;
        private static final boolean DEBUG_TRACE = false;

        private DocumentServiceAdapterCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDocumentService put(TechnologyDocumentServiceAdapterFactory.AdapterCacheKey key, IDocumentService value) {
            DocumentServiceAdapterCache documentServiceAdapterCache = this;
            synchronized (documentServiceAdapterCache) {
                key.getDocument().addDisposedListener(this);
                return super.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDocumentService remove(Object key) {
            DocumentServiceAdapterCache documentServiceAdapterCache = this;
            synchronized (documentServiceAdapterCache) {
                ((TechnologyDocumentServiceAdapterFactory.AdapterCacheKey)key).getDocument().removeDisposedListener(this);
                return (IDocumentService)super.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            DocumentServiceAdapterCache documentServiceAdapterCache = this;
            synchronized (documentServiceAdapterCache) {
                for (TechnologyDocumentServiceAdapterFactory.AdapterCacheKey key : this.keySet()) {
                    key.getDocument().removeDisposedListener(this);
                }
                super.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyDisposed(IDocument doc) {
            DocumentServiceAdapterCache documentServiceAdapterCache = this;
            synchronized (documentServiceAdapterCache) {
                HashSet<TechnologyDocumentServiceAdapterFactory.AdapterCacheKey> keysForRemoval = new HashSet<TechnologyDocumentServiceAdapterFactory.AdapterCacheKey>();
                for (TechnologyDocumentServiceAdapterFactory.AdapterCacheKey key : this.keySet()) {
                    if (!key.getDocument().equals(doc)) continue;
                    keysForRemoval.add(key);
                }
                if (keysForRemoval.size() > 0) {
                    for (TechnologyDocumentServiceAdapterFactory.AdapterCacheKey key : keysForRemoval) {
                        this.remove(key);
                    }
                }
            }
        }
    }
}

