/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.DefaultTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.IProjectTechnologyChangeListener;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryEvent;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryListener;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.project.technology.TechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.TechnologyExtensionsFactory;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractTechnologyDiscoveryProvider
implements ITechnologyDiscoveryProvider,
ITechnologyDiscoveryListener {
    protected static final String TECH_PROV_EXT_PT = "oracle.eclipse.tools.common.services.TechnologyExtension";
    private final Project _project;
    private Set<IProjectTechnologyChangeListener> _listeners;
    protected Map<ITechnologyExtensionIdentifier, ITechnologyDescriptor> _techDescriptors;
    private List<ITechnologyExtensionIdentifier> _techExtIds;

    public AbstractTechnologyDiscoveryProvider(Project project) {
        this._project = project;
        this.init();
    }

    protected void init() {
        this._listeners = new CopyOnWriteArraySet<IProjectTechnologyChangeListener>();
        this._techDescriptors = new LinkedHashMap<ITechnologyExtensionIdentifier, ITechnologyDescriptor>();
        for (ITechnologyExtensionIdentifier techId : this.getAllTechnologyProviderExtensions()) {
            ITechnologyDiscoverer discoverer = this.getDiscoverer(techId);
            TechnologyDescriptor td = new TechnologyDescriptor(techId, discoverer);
            this._techDescriptors.put(techId, td);
        }
    }

    protected synchronized ITechnologyDiscoverer getDiscoverer(ITechnologyExtensionIdentifier techId) {
        Class klass;
        String discovererClass = techId.getDiscovererClassname();
        if (discovererClass != null && !discovererClass.equals("") && (klass = PluginUtil.loadClass((String)techId.getBundleId(), (String)techId.getDiscovererClassname(), ITechnologyDiscoverer.class)) != null) {
            Class[] paramTypes = new Class[]{AbstractTechnologyDiscoveryProvider.class, ITechnologyExtensionIdentifier.class};
            Constructor constructor = null;
            try {
                constructor = klass.getConstructor(paramTypes);
                AbstractTechnologyDiscoverer discoverer = (AbstractTechnologyDiscoverer)constructor.newInstance(this, techId);
                discoverer.addListener(this);
                return discoverer;
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        return this.getDefaultTechnologyDiscoverer(techId);
    }

    protected abstract DefaultTechnologyDiscoverer getDefaultTechnologyDiscoverer(ITechnologyExtensionIdentifier var1);

    public Project getProject() {
        return this._project;
    }

    protected synchronized List<ITechnologyExtensionIdentifier> getAllTechnologyProviderExtensions() {
        if (this._techExtIds == null) {
            this._techExtIds = new ArrayList<ITechnologyExtensionIdentifier>();
            IConfigurationElement[] configElems = this.getAllTechProviderConfigurationElems();
            int i = 0;
            while (i < configElems.length) {
                IConfigurationElement config = configElems[i];
                this._techExtIds.add(new TechnologyExtensionIdentifier(config));
                ++i;
            }
            Collections.sort(this._techExtIds, new Comparator<ITechnologyExtensionIdentifier>(){

                @Override
                public int compare(ITechnologyExtensionIdentifier o1, ITechnologyExtensionIdentifier o2) {
                    if (o1.getPriority() > o2.getPriority()) {
                        return 1;
                    }
                    if (o1.getPriority() < o2.getPriority()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        return this._techExtIds;
    }

    public void addListener(IProjectTechnologyChangeListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(IProjectTechnologyChangeListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public void handleTechnologyDiscoveries(ITechnologyDiscoveryEvent event) {
        this.internalHandleTechnologiesModified(event);
        for (IProjectTechnologyChangeListener listener : this._listeners) {
            listener.notificationOfTechnologiesChanged(event);
        }
    }

    protected abstract void internalHandleTechnologiesModified(ITechnologyDiscoveryEvent var1);

    public IConfigurationElement[] getAllTechProviderConfigurationElems() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TECH_PROV_EXT_PT);
    }

    protected ITechnologyExtension createTechExt(ITechnologyDescriptor td) {
        return TechnologyExtensionsFactory.getInstance().create(this.getProject(), td);
    }

    public void projectClosing() {
        this.close();
    }

    protected void close() {
        this.stopDiscovering();
        for (ITechnologyExtension techExt : this.getActiveTechnologies()) {
            ((AbstractTechnologyExtension)techExt).close();
        }
        this._listeners.clear();
        this._techDescriptors.clear();
        this._techExtIds.clear();
    }

    private void stopDiscovering() {
        for (ITechnologyDescriptor td : this._techDescriptors.values()) {
            td.getDiscovererInstance().stop();
        }
    }

    public static final class TechnologyExtensionIdentifier
    implements ITechnologyExtensionIdentifier {
        private final IConfigurationElement _configElem;
        private Integer _priority;

        public TechnologyExtensionIdentifier(IConfigurationElement configElem) {
            this._configElem = configElem;
        }

        @Override
        public String getDescription() {
            return this._configElem.getAttribute("description");
        }

        @Override
        public String getDiscovererClassname() {
            return this._configElem.getAttribute("discovererClassname");
        }

        @Override
        public String getDisplayName() {
            return this._configElem.getAttribute("displayName");
        }

        @Override
        public String getId() {
            return this._configElem.getAttribute("id");
        }

        @Override
        public String getBundleId() {
            return this._configElem.getContributor().getName();
        }

        @Override
        public String getImplementationClassName() {
            return this._configElem.getAttribute("implementationClassname");
        }

        @Override
        public String getVersion() {
            return this._configElem.getAttribute("version");
        }

        @Override
        public int getPriority() {
            if (this._priority == null) {
                String val = this._configElem.getAttribute("priority");
                if (val == null || val.equals("")) {
                    this._priority = 10;
                } else {
                    int intVal = 10;
                    try {
                        intVal = Integer.valueOf(val);
                    }
                    catch (Exception exception) {
                        LoggingService.logError((Plugin)Activator.getDefault(), (String)("The priority attribute value for " + this.toString() + " is invalid.   Priority set to 10."));
                    }
                    this._priority = intVal;
                }
            }
            return this._priority;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("TechId: ");
            buf.append(this.getId());
            buf.append("[").append(this.getVersion()).append("]");
            return buf.toString();
        }
    }
}

