/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryEvent;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryListener;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;

public abstract class AbstractTechnologyDiscoverer
implements ITechnologyDiscoverer {
    private ITechnologyExtensionIdentifier _techId;
    private final Set<ITechnologyDiscoveryListener> _listeners;
    private final AbstractTechnologyDiscoveryProvider _techDP;

    public AbstractTechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
        this._techDP = technologyDiscoveryProvider;
        this._techId = techId;
        this._listeners = new CopyOnWriteArraySet<ITechnologyDiscoveryListener>();
    }

    @Override
    public abstract boolean isActive();

    public ITechnologyExtensionIdentifier getTechnologyId() {
        return this._techId;
    }

    public void setTechnologyId(ITechnologyExtensionIdentifier techId) {
        this._techId = techId;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public void addListener(ITechnologyDiscoveryListener listener) {
        this._listeners.add(listener);
    }

    public void removeListeners(ITechnologyDiscoveryListener listener) {
        this._listeners.remove(listener);
    }

    protected void notifyListeners(ITechnologyDiscoveryEvent event) {
        for (ITechnologyDiscoveryListener listener : this._listeners) {
            listener.handleTechnologyDiscoveries(event);
        }
    }

    @Override
    public AbstractTechnologyDiscoveryProvider getTechnologyDiscoveryProvider() {
        return this._techDP;
    }
}

