/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.internal;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.ProjectProperties;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class ProjectPropertiesImpl
implements ProjectProperties {
    private IFile _propFile;
    private static final String _fileName = ".settings/oracle.eclipse.tools.project";
    private Properties _properties;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ProjectPropertiesImpl(Project project) {
        this._propFile = this.getPropertiesFile(project);
        FileInputStream in = null;
        try {
            try {
                this._properties = new Properties();
                in = new FileInputStream(this._propFile.getRawLocation().toFile());
                this._properties.load(in);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to close project properties file");
                }
                return;
            }
            catch (InvalidPropertiesFormatException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to load project properties file");
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e2, (String)"Failed to close project properties file");
                }
                return;
            }
            catch (IOException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to load project properties file");
                if (in == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    in.close();
                    return;
                }
                catch (IOException e3) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e3, (String)"Failed to close project properties file");
                }
                return;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to close project properties file");
                }
            }
        }
    }

    @Override
    public IFile getPropertiesFile(Project project) {
        IFile file = project.getEclipseProject().getFile(_fileName);
        return file;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    @Override
    public boolean setProperty(String key, String value) {
        Object o = this._properties.setProperty(key, value);
        this.saveProps();
        return o != null;
    }

    @Override
    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String val = this.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(val);
    }

    @Override
    public boolean getBooleanProperty(String key) {
        String val = this._properties.getProperty(key);
        return Boolean.parseBoolean(val);
    }

    @Override
    public boolean setBooleanProperty(String key, boolean value) {
        Object o = this._properties.setProperty(key, String.valueOf(value));
        this.saveProps();
        return o != null;
    }

    @Override
    public int getIntProperty(String key, int defaultValue) {
        String val = this.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }

    @Override
    public int getIntProperty(String key) {
        String val = this.getProperty(key);
        if (val == null) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    @Override
    public boolean setIntProperty(String key, int value) {
        Object o = this._properties.setProperty(key, String.valueOf(value));
        this.saveProps();
        return o != null;
    }

    private void saveProps() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    OutputStream os = null;
                    FilterOutputStream bos = null;
                    try {
                        try {
                            os = new FileOutputStream(ProjectPropertiesImpl.this._propFile.getRawLocation().toFile());
                            bos = new BufferedOutputStream(os);
                            ProjectPropertiesImpl.this._properties.store(bos, null);
                        }
                        catch (FileNotFoundException e) {
                            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to find project properties file");
                            try {
                                if (bos != null) {
                                    bos.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                            }
                            catch (IOException e2) {
                                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e2, (String)"Failed to close project properties file inputstream");
                            }
                        }
                        catch (IOException e) {
                            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to save project properties file");
                            try {
                                if (bos != null) {
                                    bos.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                            }
                            catch (IOException e3) {
                                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e3, (String)"Failed to close project properties file inputstream");
                            }
                        }
                    }
                    finally {
                        try {
                            if (bos != null) {
                                bos.close();
                            }
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e) {
                            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to close project properties file inputstream");
                        }
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to run save project properties file");
        }
    }

    @Override
    public void deletePropertiesFile() {
        if (this._propFile != null && this._propFile.exists()) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        ProjectPropertiesImpl.this._propFile.delete(true, null);
                        ProjectPropertiesImpl.this._propFile = null;
                    }
                }, null);
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Failed to delete project properties file");
            }
        }
    }
}

