/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.internal;

import oracle.eclipse.tools.common.services.project.internal.IFileChangeReporter;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class EclipseDeltaVisitor
implements IResourceDeltaVisitor {
    private final IProgressMonitor mMonitor;
    private final IFileChangeReporter _reporter;
    private static final int MOVED_FLAGS = 12288;

    public EclipseDeltaVisitor(IFileChangeReporter reporter, IProgressMonitor monitor, int countFiles) {
        assert (monitor != null);
        this.mMonitor = monitor;
        this.mMonitor.beginTask("", countFiles);
        this._reporter = reporter;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        String newProject;
        String oldProject;
        IPath newPath;
        if (this.mMonitor != null && this.mMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IResource resource = delta.getResource();
        int type = resource.getType();
        boolean fileMoved = this.isFileMove(delta, resource.getType(), 12288);
        if (fileMoved && (delta.getFlags() & 0x2000) != 0 && (newPath = delta.getMovedToPath()) != null && ObjectUtil.equalObjects(oldProject = resource.getProject().getName(), newProject = newPath.segments()[0])) {
            return true;
        }
        if (type == 4 || type == 1 || type == 2) {
            String newProject2;
            String oldProject2;
            IPath oldPath;
            IProject project = resource.getProject();
            if (project.getLocation() == null) {
                return false;
            }
            if (fileMoved && (delta.getFlags() & 0x1000) != 0 && (oldPath = delta.getMovedFromPath()) != null && ObjectUtil.equalObjects(oldProject2 = oldPath.segments()[0], newProject2 = resource.getProject().getName())) {
                IFolder oldResource;
                if (type == 1) {
                    IFile oldResource2 = ResourcesPlugin.getWorkspace().getRoot().getFile(oldPath);
                    if (oldResource2 != null) {
                        this._reporter.fireResourceMoved((IResource)oldResource2, resource, this.mMonitor);
                    }
                } else if (type == 2 && (oldResource = ResourcesPlugin.getWorkspace().getRoot().getFolder(oldPath)) != null) {
                    this._reporter.fireResourceMoved((IResource)oldResource, resource, this.mMonitor);
                }
                return true;
            }
            switch (delta.getKind()) {
                case 1: {
                    if (type != 1 && type != 2) break;
                    this._reporter.fireResourceAdded(resource, this.mMonitor);
                    break;
                }
                case 2: {
                    if (resource.getLocation() == null || type != 1 && type != 2) break;
                    this._reporter.fireResourceRemoved(resource, this.mMonitor);
                    break;
                }
                case 4: {
                    if (type != 1 || (delta.getFlags() & 0x100) == 0) break;
                    this._reporter.fireResourceModified(resource, this.mMonitor);
                }
            }
        }
        boolean continueVisiting = true;
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            continueVisiting = this.visit(childDelta);
            ++n2;
        }
        return continueVisiting;
    }

    private boolean isFileMove(IResourceDelta delta, int resType, int moveType) {
        boolean movedFrom;
        boolean bl = movedFrom = (delta.getFlags() & moveType) != 0;
        return movedFrom && (resType == 1 || resType == 2);
    }
}

