/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.project.AbstractPropagatingEventSource;
import oracle.eclipse.tools.common.services.project.ExceptionHandler;
import oracle.eclipse.tools.common.services.project.FileEvent;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;

public abstract class FileChangeNotifier
extends AbstractPropagatingEventSource {
    private final Set<IFile> _fileMap = new HashSet<IFile>();

    public FileChangeNotifier() {
        this(new ExceptionHandler(){

            @Override
            public void handleException(Throwable exception) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)exception);
            }
        });
    }

    public FileChangeNotifier(ExceptionHandler handler) {
        super(handler);
    }

    public abstract void dispose();

    @Override
    protected abstract void doListenerListIsEmpty();

    @Override
    protected abstract void doListenerListNoLongerEmpty();

    public void track(IFile file) {
        this._fileMap.add(file);
    }

    @Override
    protected boolean shouldPropagate(FileEvent fileEvent) {
        switch (fileEvent.getEventType()) {
            case ADDED: 
            case REMOVED: 
            case MODIFIED: {
                if (fileEvent.getChangedResource().getType() != 1) break;
                return this._fileMap.contains(fileEvent.getChangedResource());
            }
            case MOVED: {
                IResource oldRes = fileEvent.getMovedFromLocation();
                IResource newRes = fileEvent.getMovedToLocation();
                if (oldRes.getType() == 1 && this._fileMap.contains(oldRes)) {
                    return true;
                }
                if (newRes.getType() != 1 || !this._fileMap.contains(newRes)) break;
                return true;
            }
        }
        return false;
    }

    public boolean remove(IFile file) {
        if (this._fileMap != null) {
            return this._fileMap.remove(file);
        }
        return false;
    }
}

