/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project;

import oracle.eclipse.tools.common.services.project.AbstractFileEventSource;
import oracle.eclipse.tools.common.services.project.EnvFileListener;
import oracle.eclipse.tools.common.services.project.ExceptionHandler;
import oracle.eclipse.tools.common.services.project.FileEvent;

public abstract class AbstractPropagatingEventSource
extends AbstractFileEventSource
implements EnvFileListener {
    private final ExceptionHandler _exceptionHandler;

    protected AbstractPropagatingEventSource(ExceptionHandler exceptionHandler) {
        this._exceptionHandler = exceptionHandler;
    }

    @Override
    public void fileAdded(final FileEvent event) {
        this.fireEvent(new MyRunnable(this._exceptionHandler){

            public void run() throws Exception {
                if (AbstractPropagatingEventSource.this.shouldPropagate(event)) {
                    this.getListener().fileAdded(new FileEvent(event));
                }
            }
        });
    }

    @Override
    public void fileChanged(final FileEvent event) {
        this.fireEvent(new MyRunnable(this._exceptionHandler){

            public void run() throws Exception {
                if (AbstractPropagatingEventSource.this.shouldPropagate(event)) {
                    this.getListener().fileChanged(new FileEvent(event));
                }
            }
        });
    }

    @Override
    public void fileMoved(final FileEvent event) {
        this.fireEvent(new MyRunnable(this._exceptionHandler){

            public void run() throws Exception {
                if (AbstractPropagatingEventSource.this.shouldPropagate(event)) {
                    this.getListener().fileMoved(new FileEvent(event));
                }
            }
        });
    }

    @Override
    public void fileRemoved(final FileEvent event) {
        this.fireEvent(new MyRunnable(this._exceptionHandler){

            public void run() throws Exception {
                if (AbstractPropagatingEventSource.this.shouldPropagate(event)) {
                    this.getListener().fileRemoved(new FileEvent(event));
                }
            }
        });
    }

    protected abstract boolean shouldPropagate(FileEvent var1);

    protected static abstract class MyRunnable
    extends AbstractFileEventSource.FileListenerRunnable {
        private final ExceptionHandler _exceptionHandler;

        public MyRunnable(ExceptionHandler exceptionHandler) {
            this._exceptionHandler = exceptionHandler;
        }

        public void handleException(Throwable exception) {
            this._exceptionHandler.handleException(exception);
        }
    }
}

