/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dom.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.eclipse.tools.common.services.dom.util.AbstractVisitSelectionStrategy;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleTagVisitSelectionStrategy
extends AbstractVisitSelectionStrategy<Node> {
    private final AbstractVisitSelectionStrategy.VisitOrder _visitOrder;

    public SimpleTagVisitSelectionStrategy(AbstractVisitSelectionStrategy.VisitOrder visitOrder) {
        this._visitOrder = visitOrder;
    }

    @Override
    public AbstractVisitSelectionStrategy.VisitOrder getVisitOrder() {
        return this._visitOrder;
    }

    @Override
    public Iterator<Node> getSelectionIterator(Node curNode) {
        return this.getIterator(curNode);
    }

    private Iterator<Node> getIterator(Node domNode) {
        return new TagChildIterator(domNode);
    }

    private static class TagChildIterator
    implements Iterator<Node> {
        private final NodeList _nodeList;
        private int _curIndex;
        private final int _numItems;

        public TagChildIterator(Node target) {
            this._nodeList = target.getChildNodes();
            this._curIndex = 0;
            this._numItems = this._nodeList.getLength();
        }

        @Override
        public boolean hasNext() {
            this.checkConcurrentModification();
            return this._curIndex < this._numItems;
        }

        @Override
        public Node next() {
            this.checkConcurrentModification();
            if (this._curIndex >= this._numItems) {
                throw new NoSuchElementException();
            }
            return this._nodeList.item(this._curIndex++);
        }

        private void checkConcurrentModification() {
            if (this._nodeList.getLength() != this._numItems) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

