/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dom.util;

import java.util.Iterator;
import oracle.eclipse.tools.common.services.dom.util.AbstractVisitSelectionStrategy;
import oracle.eclipse.tools.common.services.dom.util.IVisitor;
import oracle.eclipse.tools.common.services.dom.util.SimpleTagVisitSelectionStrategy;
import oracle.eclipse.tools.common.services.dom.util.VisitorAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public final class DOMVisitorAdapter
extends VisitorAdapter<IDOMNode, IDOMNode, IVisitor<Node>> {
    private final Node _root;
    private AbstractVisitSelectionStrategy<Node> _selectStrategy;

    public DOMVisitorAdapter(Node root) {
        this._root = root;
        this._selectStrategy = new SimpleTagVisitSelectionStrategy(AbstractVisitSelectionStrategy.VisitOrder.PRE_ORDER);
    }

    public void setSelectStrategy(AbstractVisitSelectionStrategy<Node> strategy) {
        this._selectStrategy = strategy;
    }

    @Override
    public void accept(IVisitor<Node> visitor) {
        switch (this._selectStrategy.getVisitOrder()) {
            case PRE_ORDER: {
                this.internalPreOrderVisit(visitor, this._root);
                break;
            }
            case POST_ORDER: {
                this.internalPostOrderVisit(visitor, this._root);
            }
        }
    }

    private void internalPreOrderVisit(IVisitor<Node> visitor, Node curRoot) {
        visitor.visit(curRoot);
        Iterator<Node> it = this._selectStrategy.getSelectionIterator(curRoot);
        while (it.hasNext()) {
            this.internalPreOrderVisit(visitor, it.next());
        }
    }

    private void internalPostOrderVisit(IVisitor<Node> visitor, Node curRoot) {
        Iterator<Node> it = this._selectStrategy.getSelectionIterator(curRoot);
        while (it.hasNext()) {
            this.internalPostOrderVisit(visitor, it.next());
        }
        visitor.visit(curRoot);
    }
}

