/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.document.internal;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.services.document.DocumentServiceAdapterFactory;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class DocumentDescriptor {
    private final String _id;
    private final List<String> _contentType;
    private final DocumentServiceAdapterFactory _serviceAdapterFactory;

    public DocumentDescriptor(String id, List<String> contentType, DocumentServiceAdapterFactory serviceAdapterFactory) {
        this._id = id;
        this._contentType = contentType.isEmpty() ? Collections.emptyList() : (contentType.size() == 1 ? Collections.singletonList(contentType.get(0)) : contentType);
        this._serviceAdapterFactory = serviceAdapterFactory;
    }

    public String getId() {
        return this._id;
    }

    public List<String> getContentType() {
        return this._contentType;
    }

    public DocumentServiceAdapterFactory getServiceAdapterFactory() {
        return this._serviceAdapterFactory;
    }

    public boolean matches(IContentDescription contentDesc) {
        boolean matches = false;
        IContentType contentType = contentDesc.getContentType();
        if (contentType != null) {
            String checkType = contentType.getId();
            for (String id : this._contentType) {
                if (!checkType.equals(id)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    public String toString() {
        return MessageFormat.format("Document Descriptor {0} for content type {1} service adapter factory={2}", this.getId(), this.getContentType(), this.getServiceAdapterFactory());
    }
}

