/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.document;

import oracle.eclipse.tools.common.services.document.HashingComparator;
import oracle.eclipse.tools.common.services.document.IDocument;

public abstract class DocumentServiceAdapterFactory {
    public final Object createAdapter(Class<?> adapterType, IDocument document) {
        return this.doCreateAdapter(adapterType, document);
    }

    protected abstract Object doCreateAdapter(Class<?> var1, IDocument var2);

    public boolean shouldCacheAdapter(Class<?> adapterType, Object adapter, IDocument document) {
        return true;
    }

    public HashingComparator getHashingComparator(Class<?> adapteryType) {
        return new HashingComparator();
    }

    static final class AdapterCacheKey {
        private final Class<?> _adapterType;
        private final HashingComparator _comparator;

        public AdapterCacheKey(Class<?> adapterType, HashingComparator comparator) {
            this._adapterType = adapterType;
            this._comparator = comparator;
        }

        public Class<?> getAdapterType() {
            return this._adapterType;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AdapterCacheKey) {
                return this._comparator.equals(this._adapterType, ((AdapterCacheKey)obj)._adapterType);
            }
            return false;
        }

        public int hashCode() {
            return this._comparator.hashCode(this._adapterType);
        }
    }
}

