/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.document;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.eclipse.tools.common.services.document.DocumentServiceAdapterFactory;
import oracle.eclipse.tools.common.services.document.HashingComparator;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentDisposedListener;
import oracle.eclipse.tools.common.services.document.internal.DocumentDescriptor;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;

public final class Document
implements IDocument {
    private final IFile _file;
    private final DocumentDescriptor _descriptor;
    private final HashMap<DocumentServiceAdapterFactory.AdapterCacheKey, Object> _adapterCache;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private final List<IDocumentDisposedListener> _docDisposedListeners;

    public Document(IFile file, DocumentDescriptor descriptor) {
        assert (file != null);
        this._file = file;
        this._descriptor = descriptor;
        this._adapterCache = new HashMap();
        this._docDisposedListeners = new CopyOnWriteArrayList<IDocumentDisposedListener>();
    }

    @Override
    public String getDocumentType() {
        return this._descriptor.getId();
    }

    @Override
    public final IFile getFile() {
        return this._file;
    }

    @Override
    public final Project getProject() {
        return (Project)this._file.getProject().getAdapter(Project.class);
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this.reset();
        }
        this.notifyDisposalListeners();
    }

    @Override
    public void reset() {
        this._adapterCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Class adapterType) {
        Object adapterObj = null;
        DocumentServiceAdapterFactory adapterFactory = this._descriptor.getServiceAdapterFactory();
        if (adapterFactory != null) {
            HashingComparator hashingComparator = adapterFactory.getHashingComparator(adapterType);
            HashMap<DocumentServiceAdapterFactory.AdapterCacheKey, Object> hashMap = this._adapterCache;
            synchronized (hashMap) {
                adapterObj = this._adapterCache.get(new DocumentServiceAdapterFactory.AdapterCacheKey(adapterType, hashingComparator));
                if (adapterObj == null && adapterFactory.shouldCacheAdapter(adapterType, adapterObj = adapterFactory.createAdapter(adapterType, this), this)) {
                    this._adapterCache.put(new DocumentServiceAdapterFactory.AdapterCacheKey(adapterType, hashingComparator), adapterObj);
                }
            }
        } else {
            adapterObj = Platform.getAdapterManager().getAdapter((Object)this, adapterType);
        }
        return adapterObj;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IDocument for file ");
        stringBuilder.append(this.getFile().toString());
        stringBuilder.append(" on project ");
        stringBuilder.append(this.getProject().toString());
        stringBuilder.append("\n");
        stringBuilder.append(this._descriptor.toString());
        return stringBuilder.toString();
    }

    public void checkpoint() {
    }

    public void destroy() {
        this.notifyDisposalListeners();
    }

    @Override
    public boolean isDisposed() {
        return this._isDisposed.get();
    }

    private void notifyDisposalListeners() {
        for (IDocumentDisposedListener listener : this._docDisposedListeners) {
            listener.notifyDisposed(this);
        }
    }

    @Override
    public void addDisposedListener(IDocumentDisposedListener listener) {
        this._docDisposedListeners.add(listener);
    }

    @Override
    public void removeDisposedListener(IDocumentDisposedListener listener) {
        if (this._docDisposedListeners.contains(listener)) {
            this._docDisposedListeners.remove(listener);
        }
    }
}

