/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.dependency.DependencyMessages;
import oracle.eclipse.tools.common.services.dependency.model.DependencyModelEvent;
import oracle.eclipse.tools.common.services.dependency.model.internal.CollectionParticipantList;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.dependency.model.internal.DiscoveryParticipantList;
import oracle.eclipse.tools.common.services.resources.ICommand;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ResourceSetCommand
implements ICommand,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IProject project;
    private final Set<IResource> changedResources = new LinkedHashSet<IResource>();
    private final Set<IResource> removedResources = new LinkedHashSet<IResource>();
    private static final IStatus STATUS_INTERRUPTED = new Status(0, "oracle.eclipse.tools.common.services", 2048, "", null);

    public ResourceSetCommand(IProject project) {
        this.project = project;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IStatus execute(IProgressMonitor monitor, ITransactionContext context, boolean avoidUpdate) {
        if (this.project == null) return Status.OK_STATUS;
        if (!this.project.isAccessible()) {
            return Status.OK_STATUS;
        }
        if (!avoidUpdate) {
            DependencyModelManager.getInstance().getModel().updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.BEFORE_UPDATE, this.project));
        }
        try {
            try {
                ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)120);
                for (IResource removedResource : this.removedResources) {
                    DependencyModelManager.getInstance().getModel().resourceRemoved(removedResource, context);
                }
                HashSet<IResource> outputResources = new HashSet<IResource>();
                for (IResource changedResource : this.changedResources) {
                    if (!this.isJavaProjectOutputResource(changedResource)) continue;
                    outputResources.add(changedResource);
                }
                for (IResource outputResource : outputResources) {
                    this.changedResources.remove(outputResource);
                }
                if (this.changedResources.size() == 0) {
                    Status status = new Status(0, "oracle.eclipse.tools.common.services", 0, DependencyMessages.bind((String)DependencyMessages.projectCollectionEmptyJob, (Object)this.project.getName()), null);
                    return status;
                }
                DiscoveryParticipantList discoveryParticipants = new DiscoveryParticipantList(this.project);
                CollectionParticipantList collectionParticipants = new CollectionParticipantList(this.project);
                this.changedResources.addAll(discoveryParticipants.getDependentResources(Collections.unmodifiableSet(this.changedResources), monitor));
                this.changedResources.addAll(collectionParticipants.getDependentResources(Collections.unmodifiableSet(this.changedResources), monitor));
                discoveryParticipants.discover(Collections.unmodifiableSet(this.changedResources), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)50));
                if (Thread.currentThread().isInterrupted()) {
                    IStatus iStatus = STATUS_INTERRUPTED;
                    return iStatus;
                }
                collectionParticipants.collect(Collections.unmodifiableSet(this.changedResources), DependencyModelManager.getInstance().getModel(), context, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)40));
                if (Thread.currentThread().isInterrupted()) {
                    IStatus iStatus = STATUS_INTERRUPTED;
                    return iStatus;
                }
            }
            finally {
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)10);
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
            if (!avoidUpdate) {
                DependencyModelManager.getInstance().getModel().updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.UPDATED, this.project));
            }
        }
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public void addResource(IResourceChange resourceChange) {
        switch (resourceChange.getKind()) {
            case ADDED: 
            case CHANGED: {
                IResource resource;
                HashSet<IResourceChange.FLAG> importantFlags = new HashSet<IResourceChange.FLAG>(resourceChange.getFlags());
                importantFlags.remove((Object)IResourceChange.FLAG.MARKERS);
                importantFlags.remove((Object)IResourceChange.FLAG.DESCRIPTION);
                if (importantFlags.isEmpty() && resourceChange.getKind() != IResourceChange.KIND.ADDED || (resource = resourceChange.getResource()).getType() != 1) break;
                this.changedResources.add(resource);
                break;
            }
            case REMOVED: {
                this.removedResources.add(resourceChange.getResource());
            }
        }
    }

    public boolean hasChanges() {
        return !this.removedResources.isEmpty() || !this.changedResources.isEmpty();
    }

    public void addAllProjectResources() {
        try {
            if (this.project.isAccessible()) {
                this.project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.isAccessible() && !resource.isTeamPrivateMember()) {
                            ResourceSetCommand.this.changedResources.add(resource);
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
        }
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(this.getProject());
        hcu.hash(this.changedResources);
        hcu.hash(this.removedResources);
        return hcu.getHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceSetCommand) {
            ResourceSetCommand command = (ResourceSetCommand)obj;
            if (this.changedResources.equals(command.changedResources) && this.removedResources.equals(command.removedResources)) {
                return this.project == null ? command.getProject() == null : this.project.equals((Object)command.getProject());
            }
        }
        return false;
    }

    public String toString() {
        return "ResourceSetCommand [" + this.project + "]";
    }

    public void printChangedResources() {
        TraceOptions.log("ResourceSetCommand changed resources: " + this.changedResources);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput(out);
        su.writeResource((IResource)this.project);
        out.writeInt(this.changedResources.size());
        for (IResource res : this.changedResources) {
            su.writeResource(res);
        }
        out.writeInt(this.removedResources.size());
        for (IResource res : this.removedResources) {
            su.writeResource(res);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalProjectFromStream(this, "project");
        int size = in.readInt();
        LinkedHashSet<IResource> cRes = new LinkedHashSet<IResource>();
        int i = 0;
        while (i < size) {
            cRes.add(su.readResource());
            ++i;
        }
        su.setFinalField(this, "changedResources", Set.class, cRes);
        size = in.readInt();
        LinkedHashSet<IResource> rRes = new LinkedHashSet<IResource>();
        int i2 = 0;
        while (i2 < size) {
            rRes.add(su.readResource());
            ++i2;
        }
        su.setFinalField(this, "removedResources", Set.class, rRes);
    }

    private boolean isJavaProjectOutputResource(IResource resource) {
        IProject project = resource.getProject();
        if (!project.exists()) {
            return false;
        }
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return false;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        Set outputPaths = null;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                outputPaths = JavaUtil.getOutputPaths((IJavaProject)javaProject);
            }
            catch (JavaModelException jme) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)((Object)jme));
            }
        }
        if (outputPaths != null) {
            for (IPath outputPath : outputPaths) {
                if (!outputPath.isPrefixOf(resource.getFullPath())) continue;
                return true;
            }
        }
        return false;
    }
}

