/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.internal.DiscoveryContextImpl;
import oracle.eclipse.tools.common.services.dependency.model.internal.DiscoveryParticipantExtensionReader;
import oracle.eclipse.tools.common.services.dependency.model.internal.Messages;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

class DiscoveryParticipantList {
    private final IProject project;
    private final Set<IDiscoveryParticipant> discoveryParticipants;

    public DiscoveryParticipantList(IProject project) {
        this.project = project;
        this.discoveryParticipants = DiscoveryParticipantExtensionReader.getParticipants(project);
    }

    public Set<IResource> getDependentResources(final Set<IResource> changedResources, final IProgressMonitor monitor) {
        final LinkedHashSet<IResource> dependentResources = new LinkedHashSet<IResource>();
        final Iterator<IDiscoveryParticipant> dpIter = this.discoveryParticipants.iterator();
        while (dpIter.hasNext()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    dependentResources.addAll(((IDiscoveryParticipant)dpIter.next()).getDependentResources(DiscoveryParticipantList.this.project, changedResources, monitor));
                }

                public void handleException(Throwable exception) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)exception);
                }
            });
        }
        return dependentResources;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discover(final Set<IResource> changedResources, final IProgressMonitor monitor) {
        timeStamp = 0L;
        try {
            if (TraceOptions.APPXRAY_PERF) {
                timeStamp = System.currentTimeMillis();
            }
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.DiscoveryParticipantList_taskName, (Object)this.project.getName()), (int)((changedResources.size() + 2) * this.discoveryParticipants.size()));
            if (this.discoveryParticipants.isEmpty() != false) return;
            discoveryContext = new DiscoveryContextImpl(this.project, changedResources, false);
            try {
                dpIter = this.discoveryParticipants.iterator();
                while (true) {
                    if (!dpIter.hasNext()) break;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            ((IDiscoveryParticipant)dpIter.next()).startDiscovery(discoveryContext, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                        }

                        public void handleException(Throwable exception) {
                            dpIter.remove();
                            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)exception);
                            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)(changedResources.size() + 1));
                        }
                    });
                }
                var8_6 = changedResources.iterator();
                while (true) {
                    if (!var8_6.hasNext()) {
                    }
                    resource = var8_6.next();
                    if (resource == null || resource.getType() != 1) continue;
                    resourceContext = discoveryContext.createContextFor((IFile)resource);
                    try {
                        var11_10 = this.discoveryParticipants.iterator();
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var16_20) {
                        if (resourceContext == null) throw var16_20;
                        resourceContext.dispose();
                        throw var16_20;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        resourceContext.dispose();
                        break;
                    }
                    while (true) {
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** while (var11_10.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        participant = var11_10.next();
                        participantTimeStamp = 0L;
                        if (TraceOptions.APPXRAY_PERF) {
                            participantTimeStamp = System.nanoTime();
                        }
                        runner = new SafeRunnerWithStatus(resourceContext, participant, monitor);
                        SafeRunner.run((ISafeRunnable)runner);
                        if (TraceOptions.APPXRAY_PERF) {
                            TraceOptions.log(String.valueOf(participant.getClass().getSimpleName()) + " for " + resource.getName() + " in project " + resource.getProject().getName() + " completed with time ns, " + (System.nanoTime() - participantTimeStamp));
                        }
                        if ((status = runner.getStatus()).getCode() != 2048) continue;
                        Thread.currentThread().interrupt();
                        if (resourceContext == null) ** continue;
                        ** continue;
lbl45:
                        // 1 sources

                        ** GOTO lbl28
                    }
lbl46:
                    // 1 sources

                    if (resourceContext == null) continue;
                    resourceContext.dispose();
                }
            }
            finally {
                var19_14 = this.discoveryParticipants.iterator();
            }
            while (true) {
                if (!var19_14.hasNext()) {
                    return;
                }
                participant = var19_14.next();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(participant, monitor){
                    private final /* synthetic */ IDiscoveryParticipant val$participant;
                    private final /* synthetic */ IProgressMonitor val$monitor;
                    {
                        this.val$participant = iDiscoveryParticipant;
                        this.val$monitor = iProgressMonitor;
                    }

                    public void run() throws Exception {
                        this.val$participant.stopDiscovery(ProgressMonitorUtil.submon((IProgressMonitor)this.val$monitor, (int)1));
                    }

                    public void handleException(Throwable exception) {
                        ProgressMonitorUtil.worked((IProgressMonitor)this.val$monitor, (int)1);
                    }
                });
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
            if (TraceOptions.APPXRAY_PERF) {
                TraceOptions.log("All discovery participants for project " + this.project.getName() + " completed with time, " + (System.currentTimeMillis() - timeStamp));
            }
        }
    }

    private static final class SafeRunnerWithStatus
    implements ISafeRunnable {
        private final IResourceDiscoveryContext resourceContext;
        private final IDiscoveryParticipant participant;
        private final IProgressMonitor monitor;
        private IStatus status;

        private SafeRunnerWithStatus(IResourceDiscoveryContext resourceContext, IDiscoveryParticipant participant, IProgressMonitor monitor) {
            this.resourceContext = resourceContext;
            this.participant = participant;
            this.monitor = monitor;
        }

        public void run() throws Exception {
            this.participant.discover(this.resourceContext, ProgressMonitorUtil.submon((IProgressMonitor)this.monitor, (int)1));
            this.status = Thread.currentThread().isInterrupted() ? new Status(0, "oracle.eclipse.tools.common.services", 2048, "", null) : Status.OK_STATUS;
        }

        public void handleException(Throwable exception) {
            if (Thread.currentThread().isInterrupted()) {
                this.status = new Status(0, "oracle.eclipse.tools.common.services", 2048, exception.getMessage(), exception);
            }
            this.status = new Status(4, "oracle.eclipse.tools.common.services", exception.getMessage(), exception);
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

