/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.model.internal.DiscoveryParticipantBuilder;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class DiscoveryParticipantExtensionReader {
    public static final String EXT_PT = "discoveryParticipant";
    private static final List<DiscoveryParticipantBuilder> sPARTICIPANTS;

    static {
        ArrayList<DiscoveryParticipantBuilder> participants = new ArrayList<DiscoveryParticipantBuilder>(5);
        try {
            Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.common.services", (String)EXT_PT);
            block5: for (IExtension extension : extensions) {
                IConfigurationElement[] elems;
                IConfigurationElement[] iConfigurationElementArray = elems = extension.getConfigurationElements();
                int n = elems.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement dependentTechnologiesElement;
                    IConfigurationElement discoveryParticipantElem = iConfigurationElementArray[n2];
                    DiscoveryParticipantBuilder builder = new DiscoveryParticipantBuilder(discoveryParticipantElem.getContributor().getName());
                    String priorityStr = PluginUtil.findOptionalAttribute((IConfigurationElement)discoveryParticipantElem, (String)"priority");
                    if (priorityStr != null) {
                        try {
                            int priority = Integer.parseInt(priorityStr);
                            builder.setPriority(priority);
                        }
                        catch (NumberFormatException nfe) {
                            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)nfe);
                        }
                    }
                    IConfigurationElement participantClassElement = PluginUtil.findOptionalElement((IConfigurationElement)discoveryParticipantElem, (String)"participant-class");
                    IConfigurationElement participantFactoryElement = null;
                    if (participantClassElement == null) {
                        participantFactoryElement = PluginUtil.findOptionalElement((IConfigurationElement)discoveryParticipantElem, (String)"participant-factory");
                        if (participantFactoryElement == null) {
                            PluginUtil.reportInvalildElement((IExtension)extension, (IConfigurationElement)discoveryParticipantElem);
                            continue block5;
                        }
                        builder.setParticipantFactoryClass(PluginUtil.findRequiredAttribute((IConfigurationElement)participantFactoryElement, (String)"factory-class"));
                    } else {
                        builder.setParticipantClass(PluginUtil.findRequiredAttribute((IConfigurationElement)participantClassElement, (String)"class-name"));
                    }
                    IConfigurationElement enablementElement = PluginUtil.findOptionalElement((IConfigurationElement)discoveryParticipantElem, (String)"enablement");
                    Expression expression = null;
                    if (enablementElement != null) {
                        expression = ExpressionConverter.getDefault().perform(enablementElement);
                        builder.setEnablementExpression(expression);
                    }
                    if ((dependentTechnologiesElement = PluginUtil.findOptionalElement((IConfigurationElement)discoveryParticipantElem, (String)"dependent-technologies")) != null) {
                        builder.setDependentTechnologies(PluginUtil.findRequiredAttribute((IConfigurationElement)dependentTechnologiesElement, (String)"value"));
                    }
                    participants.add(builder);
                    ++n2;
                }
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
        }
        catch (PluginUtil.InvalidExtensionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        sPARTICIPANTS = Collections.unmodifiableList(participants);
    }

    public static Set<IDiscoveryParticipant> getParticipants(IProject project) {
        LinkedHashSet<DiscoveryParticipantWrapper> participantWrappers = new LinkedHashSet<DiscoveryParticipantWrapper>(sPARTICIPANTS.size());
        for (DiscoveryParticipantBuilder builder : sPARTICIPANTS) {
            try {
                IDiscoveryParticipant dp;
                if (!builder.isEnabledFor(project) || (dp = builder.build()) == null) continue;
                int priority = builder.getPriority();
                participantWrappers.add(new DiscoveryParticipantWrapper(priority, dp));
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
            }
        }
        ArrayList<DiscoveryParticipantWrapper> listWrappers = new ArrayList<DiscoveryParticipantWrapper>();
        listWrappers.addAll(participantWrappers);
        Collections.sort(listWrappers, new MyComparator());
        LinkedHashSet<IDiscoveryParticipant> participants = new LinkedHashSet<IDiscoveryParticipant>();
        for (DiscoveryParticipantWrapper wrapper : listWrappers) {
            participants.add(wrapper.participant);
        }
        return participants;
    }

    private static class DiscoveryParticipantWrapper {
        int priority;
        IDiscoveryParticipant participant;

        DiscoveryParticipantWrapper(int priority, IDiscoveryParticipant participant) {
            this.priority = priority;
            this.participant = participant;
        }

        public boolean equals(Object other) {
            if (other instanceof DiscoveryParticipantWrapper) {
                return this.participant == ((DiscoveryParticipantWrapper)other).participant;
            }
            return false;
        }

        public int hashCode() {
            return this.participant.getClass().getName().hashCode() * 31 + this.priority;
        }
    }

    private static class MyComparator
    implements Comparator<DiscoveryParticipantWrapper> {
        private MyComparator() {
        }

        @Override
        public int compare(DiscoveryParticipantWrapper o1, DiscoveryParticipantWrapper o2) {
            if (o1.priority < o2.priority) {
                return -1;
            }
            if (o1.priority == o2.priority) {
                return o1.participant.getClass().getName().compareTo(o2.participant.getClass().getName());
            }
            return 1;
        }
    }
}

