/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.TypeArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactModificationOperation;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ClearArtifactsOperation;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.IArtifactStore;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.MultipleArtifactReferencesQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.MultipleArtifactsQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.MemoryStore;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.NonTransactionalArtifactAddOperation;
import oracle.eclipse.tools.common.services.dependency.model.DependencyModelEvent;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModelListener;
import oracle.eclipse.tools.common.services.dependency.model.internal.Messages;
import oracle.eclipse.tools.common.services.transaction.IQueryResult;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.transaction.InvalidOperationException;
import oracle.eclipse.tools.common.services.transaction.InvalidQueryException;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class DependencyModel
implements IDependencyModel {
    private final IArtifactStore store;
    private final ResourceArtifact rootArtifact;
    private final List<IDependencyModelListener> listeners = new ArrayList<IDependencyModelListener>();

    public DependencyModel() {
        IExtensionRegistry extensionReg = Platform.getExtensionRegistry();
        IConfigurationElement[] contributions = extensionReg.getConfigurationElementsFor("oracle.eclipse.tools.common.services.artifactStore");
        String topPriorityClass = null;
        String topPriorityNS = "oracle.eclipse.tools.common.services";
        int topPriority = Integer.MAX_VALUE;
        IConfigurationElement[] iConfigurationElementArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement curElem = iConfigurationElementArray[n2];
            String priString = curElem.getAttribute("priority");
            try {
                int priority = Integer.valueOf(priString);
                if (priority < topPriority) {
                    topPriority = priority;
                    topPriorityNS = curElem.getContributor().getName();
                    topPriorityClass = curElem.getAttribute("class");
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        Object storeObj = null;
        if (topPriorityClass != null && topPriorityNS != null) {
            storeObj = PluginUtil.instantiate((String)topPriorityNS, topPriorityClass);
        }
        this.store = storeObj instanceof IArtifactStore ? (IArtifactStore)storeObj : new MemoryStore();
        this.rootArtifact = this.initializeRootArtifact();
    }

    private ResourceArtifact initializeRootArtifact() {
        ResourceArtifact ra = this.createResourceArtifact((IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.addResourceArtifact(ra);
        return ra;
    }

    @Override
    public void addArtifact(IArtifact artifact, ITransactionContext context) {
        ArtifactModificationOperation op = new ArtifactModificationOperation(ArtifactModificationOperation.OperationType.ADD, artifact, context, null);
        try {
            this.store.modify(op);
        }
        catch (InvalidOperationException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
    }

    @Override
    public void addResourceArtifact(ResourceArtifact artifact) {
        NonTransactionalArtifactAddOperation op = new NonTransactionalArtifactAddOperation(artifact);
        try {
            this.store.modify(op);
        }
        catch (InvalidOperationException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
    }

    @Override
    public void addTypeArtifact(TypeArtifact artifact) {
        NonTransactionalArtifactAddOperation op = new NonTransactionalArtifactAddOperation(artifact);
        try {
            this.store.modify(op);
        }
        catch (InvalidOperationException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
    }

    @Override
    public ResourceArtifact ensureResourceArtifact(IResource resource) {
        if (resource == null) {
            throw new NullPointerException("resource was null");
        }
        ResourceArtifact resourceArtifact = this.getResourceArtifact(resource, null);
        if (resourceArtifact == null) {
            if (resource.getType() == 8) {
                this.addResourceArtifact(this.rootArtifact);
                return this.rootArtifact;
            }
            ResourceArtifact parentResourceArtifact = this.ensureResourceArtifact((IResource)resource.getParent());
            if (parentResourceArtifact == null) {
                return null;
            }
            resourceArtifact = this.createResourceArtifact(resource);
            this.addResourceArtifact(resourceArtifact);
        }
        return resourceArtifact;
    }

    @Override
    public ResourceArtifact ensureResourceArtifact(IResource resource, ITransactionContext context) {
        if (resource == null) {
            throw new NullPointerException("resource was null");
        }
        ResourceArtifact resourceArtifact = this.getResourceArtifact(resource, context);
        if (resourceArtifact == null) {
            if (resource.getType() == 8) {
                this.addResourceArtifact(this.rootArtifact);
                return this.rootArtifact;
            }
            ResourceArtifact parentResourceArtifact = this.ensureResourceArtifact((IResource)resource.getParent(), context);
            if (parentResourceArtifact == null) {
                return null;
            }
            resourceArtifact = this.createResourceArtifact(resource);
            this.addArtifact(resourceArtifact, context);
        }
        return resourceArtifact;
    }

    private ResourceArtifact getResourceArtifact(IResource resource, ITransactionContext context) {
        if (resource != null) {
            IPath resourcePath = resource.getFullPath();
            return this.queryArtifactByPath(resourcePath, context);
        }
        return null;
    }

    private ResourceArtifact createResourceArtifact(IResource resource) {
        return new ResourceArtifact(resource);
    }

    @Override
    public void projectClosed(IProject project, ITransactionContext context) {
        this.notifyListenersOfProjectClose(project);
        ArtifactQuery query = new ArtifactQuery.Builder().setProject(project).build();
        try {
            ResourceArtifact projectArtifact;
            IQueryResult result = this.store.query(query);
            if (result instanceof MultipleArtifactsQueryResult) {
                HashSet<IArtifact> artifacts = new HashSet<IArtifact>(((MultipleArtifactsQueryResult)result).getArtifacts());
                for (IArtifact artifact : artifacts) {
                    artifact.removeReferences();
                    this.removeOwnedArtifact(artifact, context);
                    this.removeArtifact(artifact, context);
                }
            }
            if ((projectArtifact = this.getResourceArtifact((IResource)project, context)) != null) {
                this.removeArtifact(projectArtifact, context);
            }
        }
        catch (InvalidQueryException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
    }

    @Override
    public void resourceRemoved(IResource resource, ITransactionContext context) {
        ResourceArtifact resourceArtifact = this.getResourceArtifact(resource, context);
        if (resourceArtifact == null) {
            return;
        }
        resourceArtifact.removeReferences();
        this.removeOwnedArtifact(resourceArtifact, context);
        this.removeArtifact(resourceArtifact, context);
    }

    private void removeOwnedArtifact(IArtifact owningArtifact, ITransactionContext context) {
        Set<IArtifact> ownedArtifacts = this.queryArtifactsByOwner(owningArtifact);
        for (IArtifact ownedArtifact : ownedArtifacts) {
            if (!(ownedArtifact instanceof IVirtualArtifact)) continue;
            this.removeOwnedArtifact(ownedArtifact, context);
            ownedArtifact.removeReferences();
            this.removeArtifact(ownedArtifact, context);
        }
    }

    @Override
    public IArtifact queryArtifactsByOwnerNameAndType(IArtifact owner, String name, String type) {
        ArtifactQuery query = new ArtifactQuery.Builder().setOwner(owner).setName(name).setType(type).build();
        IQueryResult result = null;
        try {
            result = this.store.query(query);
            if (result instanceof ArtifactQueryResult) {
                return ((ArtifactQueryResult)result).getArtifact();
            }
        }
        catch (InvalidQueryException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        return null;
    }

    @Override
    public Set<IArtifact> queryArtifactsByOwner(IArtifact owner) {
        ArtifactQuery query = new ArtifactQuery.Builder().setOwner(owner).build();
        IQueryResult result = null;
        try {
            result = this.store.query(query);
            if (result instanceof MultipleArtifactsQueryResult) {
                return ((MultipleArtifactsQueryResult)result).getArtifacts();
            }
        }
        catch (InvalidQueryException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        return null;
    }

    @Override
    public Set<IArtifactReference> queryArtifactsByReferredArtifact(IArtifact artifact) {
        ArtifactQuery query = new ArtifactQuery.Builder().setReferredArtifact(artifact).build();
        IQueryResult result = null;
        try {
            result = this.store.query(query);
            if (result instanceof MultipleArtifactReferencesQueryResult) {
                return ((MultipleArtifactReferencesQueryResult)result).getArtifactReferences();
            }
        }
        catch (InvalidQueryException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        return Collections.emptySet();
    }

    @Override
    public ResourceArtifact queryArtifactByPath(IPath path) {
        return this.queryArtifactByPath(path, null);
    }

    private ResourceArtifact queryArtifactByPath(IPath path, ITransactionContext context) {
        ArtifactQuery query = new ArtifactQuery.Builder().setPath(path).setTransactionContext(context).build();
        IQueryResult result = null;
        try {
            IArtifact artifact;
            result = this.store.query(query);
            if (result instanceof ArtifactQueryResult && (artifact = ((ArtifactQueryResult)result).getArtifact()) instanceof ResourceArtifact) {
                return (ResourceArtifact)artifact;
            }
        }
        catch (InvalidQueryException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        return null;
    }

    @Override
    public void removeArtifact(IArtifact artifact, ITransactionContext context) {
        ArtifactModificationOperation op = new ArtifactModificationOperation(ArtifactModificationOperation.OperationType.REMOVE, artifact, context, null);
        try {
            this.store.modify(op);
        }
        catch (InvalidOperationException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
    }

    @Override
    public Set<IArtifact> queryArtifactsByTypes(Set<String> types, IProject project) {
        ArtifactQuery query = new ArtifactQuery.Builder().setArtifactTypes(types).setProject(project).build();
        IQueryResult result = null;
        try {
            result = this.store.query(query);
            if (result instanceof MultipleArtifactsQueryResult) {
                return ((MultipleArtifactsQueryResult)result).getArtifacts();
            }
        }
        catch (InvalidQueryException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IDependencyModelListener listener) {
        List<IDependencyModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IDependencyModelListener listener) {
        List<IDependencyModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateListeners(DependencyModelEvent event) {
        List<IDependencyModelListener> list = this.listeners;
        synchronized (list) {
            for (IDependencyModelListener listener : this.listeners) {
                listener.modelChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfProjectClose(IProject project) {
        List<IDependencyModelListener> list = this.listeners;
        synchronized (list) {
            for (IDependencyModelListener listener : this.listeners) {
                listener.projectClosed(project);
            }
        }
    }

    @Override
    public void clear(IProgressMonitor monitor, ITransactionContext context) {
        ClearArtifactsOperation op = new ClearArtifactsOperation(context, monitor);
        try {
            this.store.modify(op);
        }
        catch (InvalidOperationException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        this.addArtifact(this.rootArtifact, context);
    }

    @Override
    public void clear(IProject project, IProgressMonitor monitor, final ITransactionContext context) {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.DependencyModel_clear, (Object)project.getName()), (int)1);
        try {
            try {
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        ResourceArtifact resourceArtifact = DependencyModel.this.ensureResourceArtifact(resource, context);
                        DependencyModel.this.removeOwnedArtifact(resourceArtifact, context);
                        DependencyModel.this.removeArtifact(resourceArtifact, context);
                        return true;
                    }
                });
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    @Override
    public IStatus store(IProject project, int saveNumber, int prevSaveNumber) {
        return this.store.store(project, saveNumber, prevSaveNumber);
    }

    @Override
    public IStatus load(IProject project, int saveNumber) {
        this.updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.BEFORE_UPDATE, project));
        IStatus status = this.store.load(project, saveNumber);
        this.updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.UPDATED, project));
        return status;
    }

    public IArtifactStore getDataSource() {
        return this.store;
    }
}

