/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.common.services.dependency.DependencyMessages;
import oracle.eclipse.tools.common.services.dependency.model.internal.ProjectTechnologyChangeListener;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.resources.ICommand;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

final class CreateTechnologyChangedListenerCommand
implements ICommand {
    private static final long serialVersionUID = 1L;
    private final IProject project;

    CreateTechnologyChangedListenerCommand(IProject project) {
        if (project == null) {
            throw new NullPointerException("Project can not be null.");
        }
        this.project = project;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor, ITransactionContext context, boolean avoidUpdate) {
        ProjectTechnologyChangeListener listener = new ProjectTechnologyChangeListener(this.project);
        Project prj = (Project)this.project.getAdapter(Project.class);
        if (prj == null) {
            return new Status(2, "oracle.eclipse.tools.common.services", DependencyMessages.DependencyModelManager_cantMonitorTechnologies);
        }
        prj.addTechnologiesChangedListener(listener);
        return Status.OK_STATUS;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public int hashCode() {
        return this.getProject().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CreateTechnologyChangedListenerCommand && this.project.equals((Object)((CreateTechnologyChangedListenerCommand)obj).getProject());
    }

    public String toString() {
        return "CreateTechnologyChangedListenerCommand [" + this.project + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput(out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalProjectFromStream(this, "project");
    }
}

