/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.internal.CollectionContextImpl;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.CollectionParticipantExtensionReader;
import oracle.eclipse.tools.common.services.dependency.model.internal.Messages;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;

class CollectionParticipantList {
    private final IProject project;
    private final List<ICollectionParticipant> collectionParticipants;

    public CollectionParticipantList(IProject project) {
        this.project = project;
        this.collectionParticipants = new ArrayList<ICollectionParticipant>(CollectionParticipantExtensionReader.getParticipants(project));
    }

    public Set<IResource> getDependentResources(final Set<IResource> changedResources, final IProgressMonitor monitor) {
        final LinkedHashSet<IResource> dependentResources = new LinkedHashSet<IResource>();
        final Iterator<ICollectionParticipant> cpIter = this.collectionParticipants.iterator();
        while (cpIter.hasNext()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    dependentResources.addAll(((ICollectionParticipant)cpIter.next()).getDependentResources(CollectionParticipantList.this.project, changedResources, monitor));
                }

                public void handleException(Throwable exception) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)exception);
                }
            });
        }
        return dependentResources;
    }

    /*
     * Unable to fully structure code
     */
    public void collect(Set<IResource> changedResources, IDependencyModel model, ITransactionContext txContext, final IProgressMonitor monitor) {
        timeStamp = 0L;
        try {
            if (TraceOptions.APPXRAY_PERF) {
                timeStamp = System.currentTimeMillis();
            }
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CollectionParticipantList_taskName, (Object)this.project.getName()), (int)((changedResources.size() + 2) * this.collectionParticipants.size()));
            resources = changedResources;
            while (!resources.isEmpty()) {
                currentResources = resources;
                context = new CollectionContextImpl(this.project, currentResources, model, txContext);
                try {
                    cpIter = this.collectionParticipants.iterator();
                    while (cpIter.hasNext()) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                ((ICollectionParticipant)cpIter.next()).startCollecting(context, monitor);
                                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                            }

                            public void handleException(Throwable exception) {
                                cpIter.remove();
                                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)exception);
                                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)(currentResources.size() + 1));
                            }
                        });
                    }
                    if (!this.collectionParticipants.isEmpty()) {
                        for (IResource resource : currentResources) {
                            resourceContext = context.createContextFor(resource);
                            for (final ICollectionParticipant participant : this.collectionParticipants) {
                                participantTimeStamp = 0L;
                                if (TraceOptions.APPXRAY_PERF) {
                                    participantTimeStamp = System.nanoTime();
                                }
                                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                    public void run() throws Exception {
                                        participant.collect(resourceContext, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                                        ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                                    }

                                    public void handleException(Throwable exception) {
                                        LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)exception);
                                    }
                                });
                                if (!TraceOptions.APPXRAY_PERF) continue;
                                TraceOptions.log(String.valueOf(participant.getClass().getSimpleName()) + " for " + resource.getName() + " in project " + resource.getProject().getName() + " completed with time ns, " + (System.nanoTime() - participantTimeStamp));
                            }
                            resourceContext.dispose();
                        }
                    }
                }
                finally {
                    var20_17 = this.collectionParticipants.iterator();
                    if (true) ** GOTO lbl38
                }
                {
                }
                do {
                    participant = var20_17.next();
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(participant, monitor){
                        private final /* synthetic */ ICollectionParticipant val$participant;
                        private final /* synthetic */ IProgressMonitor val$monitor;
                        {
                            this.val$participant = iCollectionParticipant;
                            this.val$monitor = iProgressMonitor;
                        }

                        public void run() throws Exception {
                            this.val$participant.stopCollecting(this.val$monitor);
                            ProgressMonitorUtil.worked((IProgressMonitor)this.val$monitor, (int)1);
                        }

                        public void handleException(Throwable exception) {
                            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)exception);
                        }
                    });
lbl38:
                    // 2 sources

                } while (var20_17.hasNext());
                resources = context.getDependentResources();
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
            if (TraceOptions.APPXRAY_PERF) {
                TraceOptions.log("All collection participants for project " + this.project.getName() + " completed with time, " + (System.currentTimeMillis() - timeStamp));
            }
        }
    }
}

