/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.model.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.Preferences;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionParticipant;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class CollectionParticipantBuilder {
    private String participantClassName = null;
    private String participantFactoryClassName = null;
    private List<String> dependentTechnologies = null;
    private Expression expression = null;
    private final String pluginID;

    public CollectionParticipantBuilder(String pluginID) {
        this.pluginID = pluginID;
    }

    public ICollectionParticipant build() {
        if (this.participantClassName == null && this.participantFactoryClassName == null) {
            throw new IllegalStateException("Exactly one of participant-class or participant-factory is allowed");
        }
        ICollectionParticipant cp = null;
        if (this.participantClassName != null) {
            cp = (ICollectionParticipant)PluginUtil.instantiate((String)this.pluginID, (String)this.participantClassName, ICollectionParticipant.class);
            if (cp == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to instantiate " + this.participantClassName + " for plugin " + this.pluginID));
            }
        } else {
            Class participantFactoryClass = PluginUtil.loadClass((String)this.pluginID, (String)this.participantFactoryClassName);
            if (participantFactoryClass != null) {
                try {
                    Method getParticipantMethod = participantFactoryClass.getMethod("getParticipant", null);
                    Object participant = getParticipantMethod.invoke(null, null);
                    if (participant instanceof ICollectionParticipant) {
                        cp = (ICollectionParticipant)participant;
                    } else {
                        LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)(String.valueOf(this.participantFactoryClassName) + "#getParticipant() did not return an instance of ICollectionParticipant"));
                    }
                }
                catch (NoSuchMethodException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
            }
        }
        return cp;
    }

    public CollectionParticipantBuilder setParticipantClass(String participantClassName) {
        if (this.participantFactoryClassName != null) {
            throw new IllegalStateException("Exactly one of participant-class or participant-factory is allowed");
        }
        this.participantClassName = participantClassName;
        return this;
    }

    public CollectionParticipantBuilder setParticipantFactoryClass(String participantFactoryClassName) {
        if (this.participantClassName != null) {
            throw new IllegalStateException("Exactly one of participant-class or participant-factory is allowed");
        }
        this.participantFactoryClassName = participantFactoryClassName;
        return this;
    }

    public CollectionParticipantBuilder setEnablementExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public CollectionParticipantBuilder setDependentTechnologies(String technologies) {
        this.dependentTechnologies = StringUtil.split((String)technologies, (char)',');
        return this;
    }

    public boolean isEnabledFor(IProject project) throws CoreException {
        boolean isEnabled = true;
        if (this.expression != null) {
            EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
            evalContext.setAllowPluginActivation(true);
            boolean bl = isEnabled = EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
        }
        if (!isEnabled) {
            return false;
        }
        Project prj = (Project)project.getAdapter(Project.class);
        if (prj == null) {
            return false;
        }
        Set<ITechnologyExtension> activeExtensions = prj.getTechnologyExtensions();
        HashMap<String, HashSet<String>> techMap = new HashMap<String, HashSet<String>>(activeExtensions.size(), 1.0f);
        for (ITechnologyExtension ite : activeExtensions) {
            HashSet<String> versionSet = (HashSet<String>)techMap.get(ite.getId());
            if (versionSet == null) {
                versionSet = new HashSet<String>();
                techMap.put(ite.getId(), versionSet);
            }
            versionSet.add(ite.getVersion());
        }
        if (this.dependentTechnologies != null) {
            Activator plugin = Activator.getDefault();
            if (plugin == null) {
                LoggingService.logWarning((String)"oracle.eclipse.tools.common.services", (String)"Plugin is shut down, resource change will not be processed");
                return false;
            }
            Preferences prefs = plugin.getPreferences().getProjectPreferences(project);
            for (String dependentTechStr : this.dependentTechnologies) {
                List techStrs = StringUtil.split((String)dependentTechStr, (char)'|');
                boolean isTechStrEnabled = false;
                for (String technology : techStrs) {
                    technology = technology.trim();
                    int colonIndex = technology.indexOf(58);
                    String tech = null;
                    String version = null;
                    if (colonIndex != -1) {
                        tech = technology.substring(0, colonIndex);
                        version = technology.substring(colonIndex + 1);
                    } else {
                        tech = technology;
                    }
                    Set activeVersions = (Set)techMap.get(tech);
                    if (activeVersions == null) continue;
                    if (version == null) {
                        boolean hasAnyEnabledVersion = false;
                        for (String activeVersion : activeVersions) {
                            if (!prefs.isTechnologyExtensionActiveForCollection(tech, activeVersion)) continue;
                            hasAnyEnabledVersion = true;
                            break;
                        }
                        isTechStrEnabled = hasAnyEnabledVersion;
                    } else if (activeVersions.contains(version)) {
                        isTechStrEnabled = prefs.isTechnologyExtensionActiveForCollection(tech, version);
                    }
                    if (isTechStrEnabled) break;
                }
                if (!(isEnabled &= isTechStrEnabled)) break;
            }
        }
        return isEnabled;
    }
}

