/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.storage.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.MultipleArtifactReferencesQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.MultipleArtifactsQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.MemoryStore;
import oracle.eclipse.tools.common.services.transaction.IQuery;
import oracle.eclipse.tools.common.services.transaction.IQueryResult;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class MemoryStoreTransaction {
    private final Set<IArtifact> addedArtifacts = new LinkedHashSet<IArtifact>();
    private final Set<IArtifact> removedArtifacts = new LinkedHashSet<IArtifact>();
    private final Set<IArtifactReference> addedArtifactReferences = new LinkedHashSet<IArtifactReference>();
    private final Set<IArtifactReference> removedArtifactReferences = new LinkedHashSet<IArtifactReference>();
    private boolean isCleared = false;
    private final MemoryStore.MemoryStoreTransactionBridge bridge;

    MemoryStoreTransaction(long transactionID, MemoryStore.MemoryStoreTransactionBridge bridge) {
        this.bridge = bridge;
    }

    IStatus apply(IProgressMonitor monitor) {
        if (this.isCleared) {
            this.bridge.clear(monitor);
        } else {
            for (IArtifact removedArtifact : this.removedArtifacts) {
                this.bridge.remove(removedArtifact);
            }
        }
        for (IArtifact addedArtifact : this.addedArtifacts) {
            this.bridge.add(addedArtifact);
        }
        return Status.OK_STATUS;
    }

    IQueryResult reconcile(IQuery query, IQueryResult result) {
        if (result instanceof MultipleArtifactsQueryResult) {
            Set<Object> committedArtifacts = null;
            if (this.isCleared) {
                committedArtifacts = new HashSet();
            } else {
                committedArtifacts = ((MultipleArtifactsQueryResult)result).getArtifacts();
                committedArtifacts.removeAll(this.removedArtifacts);
            }
            committedArtifacts.addAll(this.filterArtifacts(this.addedArtifacts, query));
            return new MultipleArtifactsQueryResult(committedArtifacts);
        }
        if (result instanceof ArtifactQueryResult) {
            IArtifact artifact = null;
            if (!this.isCleared && this.removedArtifacts.contains(artifact = ((ArtifactQueryResult)result).getArtifact())) {
                artifact = null;
            }
            if (artifact == null) {
                artifact = this.filterArtifact(this.addedArtifacts, query);
            }
            return new ArtifactQueryResult(artifact);
        }
        if (result instanceof MultipleArtifactReferencesQueryResult) {
            Set<Object> committedArtifactReferences = null;
            if (this.isCleared) {
                committedArtifactReferences = new HashSet();
            } else {
                committedArtifactReferences = ((MultipleArtifactReferencesQueryResult)result).getArtifactReferences();
                committedArtifactReferences.removeAll(this.removedArtifactReferences);
            }
            committedArtifactReferences.addAll(this.filterArtifactReferences(this.addedArtifactReferences, query));
            return new MultipleArtifactReferencesQueryResult(committedArtifactReferences);
        }
        return result;
    }

    public void add(IArtifact artifact) {
        this.addedArtifacts.add(artifact);
    }

    public void remove(IArtifact artifact) {
        this.addedArtifacts.remove(artifact);
        this.removedArtifacts.add(artifact);
    }

    public void clear() {
        this.addedArtifactReferences.clear();
        this.addedArtifacts.clear();
        this.removedArtifactReferences.clear();
        this.removedArtifacts.clear();
        this.isCleared = true;
    }

    private Set<IArtifactReference> filterArtifactReferences(Set<IArtifactReference> artifactReferences, IQuery query) {
        return Collections.emptySet();
    }

    private IArtifact filterArtifact(Set<IArtifact> artifacts, IQuery query) {
        block2: {
            ArtifactQuery artifactQuery;
            block3: {
                if (!(query instanceof ArtifactQuery)) break block2;
                artifactQuery = (ArtifactQuery)query;
                if (artifactQuery.getPath() == null) break block3;
                for (IArtifact artifact : artifacts) {
                    if (!(artifact instanceof ResourceArtifact)) continue;
                    IResource resource = ((ResourceArtifact)artifact).getLocation().getResource();
                    if (!artifactQuery.getPath().equals((Object)resource.getFullPath())) continue;
                    return artifact;
                }
                break block2;
            }
            if (artifactQuery.getOwner() == null || artifactQuery.getName() == null || artifactQuery.getType() == null) break block2;
            for (IArtifact artifact : artifacts) {
                if (!artifactQuery.getOwner().equals(artifact.getOwner()) || !artifactQuery.getName().equals(artifact.getName()) || !artifactQuery.getType().equals(artifact.getType())) continue;
                return artifact;
            }
        }
        return null;
    }

    private Set<IArtifact> filterArtifacts(Set<IArtifact> artifacts, IQuery query) {
        block4: {
            LinkedHashSet<IArtifact> matchingArtifacts;
            ArtifactQuery artifactQuery;
            block6: {
                block5: {
                    if (!(query instanceof ArtifactQuery)) break block4;
                    artifactQuery = (ArtifactQuery)query;
                    matchingArtifacts = new LinkedHashSet<IArtifact>();
                    if (artifactQuery.getArtifactTypes() == null) break block5;
                    for (IArtifact artifact : artifacts) {
                        if (!artifactQuery.getProject().equals((Object)artifact.getProject()) || !artifactQuery.getArtifactTypes().contains(artifact.getType())) continue;
                        matchingArtifacts.add(artifact);
                    }
                    break block4;
                }
                if (artifactQuery.getProject() == null) break block6;
                for (IArtifact artifact : artifacts) {
                    if (!artifactQuery.getProject().equals((Object)artifact.getProject())) continue;
                    matchingArtifacts.add(artifact);
                }
                break block4;
            }
            if (artifactQuery.getReferredArtifact() != null) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            if (artifactQuery.getOwner() == null) break block4;
            for (IArtifact artifact : artifacts) {
                if (!artifactQuery.getOwner().equals(artifact.getOwner())) continue;
                matchingArtifacts.add(artifact);
            }
        }
        return Collections.emptySet();
    }
}

