/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.storage.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.TypeArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactModificationOperation;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ArtifactQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.ClearArtifactsOperation;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.IArtifactStore;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.MultipleArtifactReferencesQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.MultipleArtifactsQueryResult;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.MemoryStorePersistenceManager;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.MemoryStoreTransaction;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.MemoryStoreTransactionManager;
import oracle.eclipse.tools.common.services.dependency.artifact.storage.internal.NonTransactionalArtifactAddOperation;
import oracle.eclipse.tools.common.services.transaction.IModificationOperation;
import oracle.eclipse.tools.common.services.transaction.IQuery;
import oracle.eclipse.tools.common.services.transaction.IQueryResult;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.transaction.InvalidOperationException;
import oracle.eclipse.tools.common.services.transaction.InvalidQueryException;
import oracle.eclipse.tools.common.services.transaction.TransactionService;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class MemoryStore
implements IArtifactStore {
    private final transient Set<IArtifact> mArtifacts = new HashSet<IArtifact>();
    private final transient Map<IArtifact, Set<IArtifact>> mOwnerIndex = new HashMap<IArtifact, Set<IArtifact>>();
    private final transient Map<IPath, ResourceArtifact> mPathIndex = new HashMap<IPath, ResourceArtifact>();
    private final transient Map<String, Set<IArtifact>> mTypeIndex = new HashMap<String, Set<IArtifact>>();
    private final transient Map<IProject, Set<IArtifact>> mProjectIndex = new HashMap<IProject, Set<IArtifact>>();
    private final transient MemoryStoreTransactionManager mTransactionManager = new MemoryStoreTransactionManager();
    private final transient MemoryStorePersistenceManager mPersistenceManager = new MemoryStorePersistenceManager(this);
    private final transient MemoryStoreTransactionBridge mTransactionBridge = new MemoryStoreTransactionBridge();
    private final transient Object mIndexSynchronizedLock = new Object();

    @Override
    public void modify(IModificationOperation operation) throws InvalidOperationException {
        block7: {
            block8: {
                MemoryStoreTransaction tx;
                block6: {
                    tx = this.mTransactionManager.getTransaction(operation);
                    if (!(operation instanceof ClearArtifactsOperation)) break block6;
                    tx.clear();
                    break block7;
                }
                if (!(operation instanceof ArtifactModificationOperation)) break block8;
                ArtifactModificationOperation artifactOp = (ArtifactModificationOperation)operation;
                switch (artifactOp.getType()) {
                    case ADD: {
                        tx.add(artifactOp.getArtifact());
                        break block7;
                    }
                    case REMOVE: {
                        tx.remove(artifactOp.getArtifact());
                        break block7;
                    }
                    default: {
                        throw new InvalidOperationException();
                    }
                }
            }
            if (operation instanceof NonTransactionalArtifactAddOperation) {
                this.mTransactionBridge.add(((NonTransactionalArtifactAddOperation)operation).getArtifact());
            } else {
                throw new InvalidOperationException(operation.toString());
            }
        }
    }

    @Override
    public IQueryResult query(IQuery query) throws InvalidQueryException {
        if (query instanceof ArtifactQuery) {
            ArtifactQuery artifactQuery = (ArtifactQuery)query;
            IQueryResult result = null;
            if (artifactQuery.getPath() != null) {
                result = new ArtifactQueryResult(this.queryArtifactByPath(artifactQuery.getPath()));
            } else if (artifactQuery.getArtifactTypes() != null) {
                result = new MultipleArtifactsQueryResult(this.queryArtifactsByTypes(artifactQuery.getArtifactTypes(), artifactQuery.getProject()));
            } else if (artifactQuery.getProject() != null) {
                result = new MultipleArtifactsQueryResult(this.queryArtifactsByProject(artifactQuery.getProject()));
            } else if (artifactQuery.getReferredArtifact() != null) {
                result = new MultipleArtifactReferencesQueryResult(this.queryArtifactsByReferredArtifact(artifactQuery.getReferredArtifact()));
            } else {
                IArtifact owner = artifactQuery.getOwner();
                String name = artifactQuery.getName();
                String type = artifactQuery.getType();
                if (owner != null) {
                    result = name == null || type == null ? new MultipleArtifactsQueryResult(this.queryArtifactsByOwner(owner)) : new ArtifactQueryResult(this.queryArtifactsByOwnerNameAndType(owner, name, type));
                }
            }
            MemoryStoreTransaction tx = this.mTransactionManager.getTransaction(artifactQuery);
            if (tx != null) {
                result = tx.reconcile(query, result);
            }
            return result;
        }
        throw new InvalidQueryException(query.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IArtifact queryArtifactsByOwnerNameAndType(IArtifact owner, String name, String type) {
        Object object = this.mIndexSynchronizedLock;
        synchronized (object) {
            Set<IArtifact> ownedArtifacts = this.mOwnerIndex.get(owner);
            if (ownedArtifacts != null) {
                for (IArtifact artifact : ownedArtifacts) {
                    if (!name.equals(artifact.getName()) || !type.equals(artifact.getType())) continue;
                    return artifact;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IArtifact> queryArtifactsByOwner(IArtifact owner) {
        LinkedHashSet<IArtifact> copy = null;
        Object object = this.mIndexSynchronizedLock;
        synchronized (object) {
            Set<IArtifact> artifacts = this.mOwnerIndex.get(owner);
            if (artifacts == null) {
                return Collections.emptySet();
            }
            copy = new LinkedHashSet<IArtifact>(artifacts.size(), 1.0f);
            copy.addAll(artifacts);
        }
        return Collections.unmodifiableSet(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IArtifact> queryArtifactsByTypes(Set<String> artifactTypes, IProject project) {
        HashSet<IArtifact> artifacts = new HashSet<IArtifact>();
        Object object = this.mIndexSynchronizedLock;
        synchronized (object) {
            for (String type : artifactTypes) {
                Set<IArtifact> typedArtifacts = this.mTypeIndex.get(type);
                if (typedArtifacts == null) continue;
                for (IArtifact artifact : typedArtifacts) {
                    if ((project != null || artifact.getProject() != null) && (project == null || !project.equals((Object)artifact.getProject()))) continue;
                    artifacts.add(artifact);
                }
            }
        }
        if (artifacts.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(artifacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceArtifact queryArtifactByPath(IPath path) {
        Object object = this.mIndexSynchronizedLock;
        synchronized (object) {
            return this.mPathIndex.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IArtifactReference> queryArtifactsByReferredArtifact(IArtifact artifact) {
        LinkedHashSet<IArtifactReference> referringArtifacts = new LinkedHashSet<IArtifactReference>();
        LinkedHashSet<IArtifactReference> referencesToCheck = new LinkedHashSet<IArtifactReference>();
        Object object = this.mIndexSynchronizedLock;
        synchronized (object) {
            for (IArtifact referringArtifact : this.mArtifacts) {
                for (IArtifactReference reference : referringArtifact.getReferences()) {
                    referencesToCheck.add(reference);
                }
            }
        }
        for (IArtifactReference reference : referencesToCheck) {
            if (!reference.refersTo(artifact)) continue;
            referringArtifacts.add(reference);
        }
        return Collections.unmodifiableSet(referringArtifacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IArtifact> queryArtifactsByProject(IProject project) {
        Set<IArtifact> projectArtifacts = null;
        Object object = this.mIndexSynchronizedLock;
        synchronized (object) {
            projectArtifacts = this.mProjectIndex.get(project);
            projectArtifacts = projectArtifacts == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<IArtifact>(projectArtifacts));
        }
        return projectArtifacts;
    }

    @Override
    public void start(ITransactionContext context) {
        this.mTransactionManager.start(context, this.mTransactionBridge);
    }

    @Override
    public void end(ITransactionContext context) {
        this.mTransactionManager.end(context);
    }

    @Override
    public IStatus prepare(ITransactionContext context) {
        return this.mTransactionManager.prepare(context);
    }

    @Override
    public void commit(ITransactionContext context, IProgressMonitor monitor) {
        this.mTransactionManager.commit(context, monitor);
    }

    @Override
    public void rollback(ITransactionContext context) {
        this.mTransactionManager.rollback(context);
    }

    @Override
    public void forget(ITransactionContext context) {
        this.mTransactionManager.forget(context);
    }

    @Override
    public IStatus load(IProject project, int saveNumber) {
        ITransactionContext ctx = TransactionService.getInstance().createTransaction();
        try {
            IStatus iStatus = this.mPersistenceManager.load(project, saveNumber, ctx);
            return iStatus;
        }
        finally {
            TransactionService.getInstance().commit(ctx, null);
        }
    }

    @Override
    public IStatus store(IProject project, int saveNumber, int prevSaveNumber) {
        ITransactionContext ctx = TransactionService.getInstance().createTransaction();
        try {
            IStatus iStatus = this.mPersistenceManager.store(project, saveNumber, prevSaveNumber, ctx);
            return iStatus;
        }
        finally {
            TransactionService.getInstance().commit(ctx, null);
        }
    }

    class MemoryStoreTransactionBridge {
        MemoryStoreTransactionBridge() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(IArtifact artifact) {
            Object object = MemoryStore.this.mIndexSynchronizedLock;
            synchronized (object) {
                IProject project;
                MemoryStore.this.mArtifacts.add(artifact);
                HashSet<IArtifact> ownedArtifacts = (HashSet<IArtifact>)MemoryStore.this.mOwnerIndex.get(artifact.getOwner());
                if (ownedArtifacts == null) {
                    ownedArtifacts = new HashSet<IArtifact>();
                    MemoryStore.this.mOwnerIndex.put(artifact.getOwner(), ownedArtifacts);
                }
                ownedArtifacts.add(artifact);
                HashSet<IArtifact> typedArtifacts = (HashSet<IArtifact>)MemoryStore.this.mTypeIndex.get(artifact.getType());
                if (typedArtifacts == null) {
                    typedArtifacts = new HashSet<IArtifact>();
                    MemoryStore.this.mTypeIndex.put(artifact.getType(), typedArtifacts);
                }
                typedArtifacts.add(artifact);
                if (artifact instanceof ResourceArtifact) {
                    IResource resource = ((ResourceArtifact)artifact).getLocation().getResource();
                    IPath path = resource.getFullPath();
                    MemoryStore.this.mPathIndex.put(path, (ResourceArtifact)artifact);
                    HashSet<IArtifact> projectArtifacts = (HashSet<IArtifact>)MemoryStore.this.mProjectIndex.get(resource.getProject());
                    if (projectArtifacts == null) {
                        projectArtifacts = new HashSet<IArtifact>();
                        MemoryStore.this.mProjectIndex.put(resource.getProject(), projectArtifacts);
                    }
                    projectArtifacts.add(artifact);
                } else if (artifact instanceof TypeArtifact && (project = artifact.getProject()) != null) {
                    HashSet<IArtifact> projectArtifacts = (HashSet<IArtifact>)MemoryStore.this.mProjectIndex.get(project);
                    if (projectArtifacts == null) {
                        projectArtifacts = new HashSet<IArtifact>();
                        MemoryStore.this.mProjectIndex.put(project, projectArtifacts);
                    }
                    projectArtifacts.add(artifact);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(IArtifact artifact) {
            Object object = MemoryStore.this.mIndexSynchronizedLock;
            synchronized (object) {
                Set typedArtifacts;
                Set projectArtifacts;
                IProject project;
                Set ownedArtifacts;
                MemoryStore.this.mArtifacts.remove(artifact);
                MemoryStore.this.mOwnerIndex.remove(artifact);
                IArtifact owningArtifact = artifact.getOwner();
                if (owningArtifact != null && (ownedArtifacts = (Set)MemoryStore.this.mOwnerIndex.get(owningArtifact)) != null) {
                    ownedArtifacts.remove(artifact);
                    if (ownedArtifacts.isEmpty()) {
                        MemoryStore.this.mOwnerIndex.remove(owningArtifact);
                    }
                }
                if (artifact instanceof ResourceArtifact) {
                    IResource resource = ((ResourceArtifact)artifact).getLocation().getResource();
                    IPath path = resource.getFullPath();
                    MemoryStore.this.mPathIndex.remove(path);
                    Set projectArtifacts2 = (Set)MemoryStore.this.mProjectIndex.get(resource.getProject());
                    if (projectArtifacts2 != null) {
                        projectArtifacts2.remove(artifact);
                        if (projectArtifacts2.isEmpty()) {
                            MemoryStore.this.mProjectIndex.remove(resource.getProject());
                        }
                    }
                } else if (artifact instanceof TypeArtifact && (project = artifact.getProject()) != null && (projectArtifacts = (Set)MemoryStore.this.mProjectIndex.get(project)) != null) {
                    projectArtifacts.remove(artifact);
                    if (projectArtifacts.isEmpty()) {
                        MemoryStore.this.mProjectIndex.remove(project);
                    }
                }
                if ((typedArtifacts = (Set)MemoryStore.this.mTypeIndex.get(artifact.getType())) != null) {
                    typedArtifacts.remove(artifact);
                    if (typedArtifacts.isEmpty()) {
                        MemoryStore.this.mTypeIndex.remove(artifact.getType());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(IProgressMonitor monitor) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)5);
            try {
                Object object = MemoryStore.this.mIndexSynchronizedLock;
                synchronized (object) {
                    MemoryStore.this.mArtifacts.clear();
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                    MemoryStore.this.mOwnerIndex.clear();
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                    MemoryStore.this.mPathIndex.clear();
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                    MemoryStore.this.mTypeIndex.clear();
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                    MemoryStore.this.mProjectIndex.clear();
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                }
            }
            finally {
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
        }
    }
}

