/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.discovery.internal;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.internal.ResourceDiscoveryContextImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;

public class DiscoveryContextImpl
extends PlatformObject
implements IDiscoveryContext {
    private final Set<IResource> changedResources;
    private final IProject project;
    private final boolean isWorkingCopy;

    public DiscoveryContextImpl(IProject project, Set<IResource> changedResources, boolean isWorkingCopy) {
        this.changedResources = Collections.unmodifiableSet(changedResources);
        this.project = project;
        this.isWorkingCopy = isWorkingCopy;
    }

    @Override
    public Set<IResource> getChangedResources() {
        return this.changedResources;
    }

    public IResourceDiscoveryContext createContextFor(IFile file) {
        return new ResourceDiscoveryContextImpl(file, this.isWorkingCopy);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public boolean isWorkingCopy() {
        return this.isWorkingCopy;
    }
}

