/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact.collection.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.TypeReference;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ArtifactException;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.internal.ResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceReference;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class CollectionContextImpl
implements CollectionContext {
    private final IDependencyModel model;
    private final IProject project;
    private final Set<IResource> allChangedResources;
    private final Set<IResource> dependentResources = new HashSet<IResource>();
    private final ITransactionContext txContext;

    public CollectionContextImpl(IProject project, Set<IResource> allChangedResource, IDependencyModel model, ITransactionContext txContext) {
        this.model = model;
        this.project = project;
        this.allChangedResources = Collections.unmodifiableSet(allChangedResource);
        if (txContext == null) {
            throw new NullPointerException("transaction must not be null.");
        }
        this.txContext = txContext;
    }

    @Override
    public Set<IResource> getChangedResources() {
        return this.allChangedResources;
    }

    public boolean addDependentResource(IResource resource) {
        return this.allChangedResources.contains(resource) ? false : this.dependentResources.add(resource);
    }

    public Set<IResource> getDependentResources() {
        return Collections.unmodifiableSet(this.dependentResources);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public IResourceCollectionContext createContextFor(IResource resource) {
        return new ResourceCollectionContext(this, resource);
    }

    @Override
    public void addArtifact(IArtifact artifact, String artifactCollectorID) {
        this.model.addArtifact(artifact, this.txContext);
    }

    @Override
    public void addDocumentToResourceDependancy(IResource resourceDependedOn, ResourceLocation referenceLocation, byte refType, String artifactCollectorID) {
        IResource dependantResource = referenceLocation.getResource();
        ResourceArtifact dependantResourceArtifact = this.ensureResourceArtifact(dependantResource);
        dependantResourceArtifact.addReference(new ResourceReference(dependantResourceArtifact, referenceLocation, resourceDependedOn, artifactCollectorID));
        if (TraceOptions.MARKERS_DOCUMENT_TO_RESOURCE_REF) {
            String message = String.format("Dependency found on document: %s", resourceDependedOn.getFullPath());
            referenceLocation.createProblemMarker(message, 0);
            if (TraceOptions.APPXRAY_TRACE) {
                TraceOptions.log(message);
            }
        }
    }

    @Override
    public void addReferencedArtifact(IArtifact referantArtifact, IArtifactReference reference, boolean validateOnContentChange, byte refType) {
        referantArtifact.addReference(reference);
    }

    @Override
    public void addReferencedResource(IArtifact referantArtifact, IResource referredToResource, boolean validateOnContentChange, ResourceLocation referenceLocation, byte refType, String artifactCollectorID) {
        ResourceReference resourceReference = new ResourceReference(referantArtifact, referenceLocation, referredToResource, artifactCollectorID);
        this.addReferencedArtifact(referantArtifact, resourceReference, validateOnContentChange, refType);
        if (TraceOptions.MARKERS_RESOURCE_REF) {
            String message = String.format("Reference to resource found: %s", referredToResource.getFullPath());
            referenceLocation.createProblemMarker(message, 0);
            if (TraceOptions.APPXRAY_TRACE) {
                TraceOptions.log(String.valueOf(message) + ", from " + referenceLocation.toString());
            }
        }
    }

    @Override
    public void addTypeReference(IArtifact referantArtifact, IProject typeProject, String typeName, ResourceLocation referenceLocation, boolean addSuperDataTypes, String artifactCollectorID) {
        if (referantArtifact != null) {
            TypeReference ref = new TypeReference(referantArtifact, typeProject, typeName, referenceLocation, artifactCollectorID);
            this.addArtifact(ref.getTargetArtifact(), artifactCollectorID);
            referantArtifact.addReference(ref);
        }
    }

    @Override
    public ResourceArtifact ensureResourceArtifact(IResource resource) {
        return this.model.ensureResourceArtifact(resource, this.txContext);
    }

    @Override
    public IArtifact findArtifact(Integer ownerId, String type, String name) throws ArtifactException {
        return null;
    }

    @Override
    public Collection<IArtifact> findArtifactsByTypes(Collection<String> artifactTypes) throws ArtifactException {
        return null;
    }

    @Override
    public Collection<? extends IArtifact> getArtifactReferences(IArtifact artifact) {
        return null;
    }

    @Override
    public Set<Integer> getArtifactReferencesByID(Integer artifactId) {
        return null;
    }

    @Override
    public Set<IArtifact> getChildren(IArtifact parent, String artifact_type) {
        return null;
    }

    @Override
    public Set<Integer> getReferringArtifactIDsByID(Integer artifactId, boolean forValidationOnly) {
        return null;
    }

    @Override
    public Set<Integer> getReferringArtifacts(IArtifact artifact, boolean forValidationOnly) {
        return null;
    }

    @Override
    public Collection<? extends IArtifact> getReferringArtifactsByID(Integer artifactId, boolean forValidationOnly) {
        return null;
    }

    @Override
    public boolean hasIncludeDependants(ResourceArtifact fileArtifact) {
        return false;
    }

    @Override
    public IArtifact loadArtifact(Integer id) throws ArtifactException {
        return null;
    }

    @Override
    public void updateArtifact(IArtifact artifact) throws ArtifactException {
    }

    @Override
    public void updateCollectionDate(ResourceArtifact fileArtifact) {
    }

    @Override
    public void updateCollectionDate(IResource resource) {
    }

    @Override
    public void resetCollection(IArtifact artifact, String artifactCollectorID) {
        artifact.removeReferences(artifactCollectorID, this.txContext);
        for (IArtifact child : this.model.queryArtifactsByOwner(artifact)) {
            if (!(child instanceof IVirtualArtifact) || !artifactCollectorID.equals(((IVirtualArtifact)child).getCollectorID())) continue;
            this.resetCollection(child, artifactCollectorID);
            this.model.removeArtifact(child, this.txContext);
        }
    }

    @Override
    public void resetCollection(IArtifact artifact, String artifactCollectorID, IResource onlyForThisResource) {
        artifact.removeReferences(artifactCollectorID, this.txContext);
        for (IArtifact child : this.model.queryArtifactsByOwner(artifact)) {
            if (!(child instanceof IVirtualArtifact) || !artifactCollectorID.equals(((IVirtualArtifact)child).getCollectorID()) || !onlyForThisResource.equals((Object)((IVirtualArtifact)child).getLocation().getResource())) continue;
            this.resetCollection(child, artifactCollectorID, onlyForThisResource);
            this.model.removeArtifact(child, this.txContext);
        }
    }

    @Override
    public void removeReferences(ResourceArtifact artifact, String artifactCollectorID) {
        artifact.removeReferences(artifactCollectorID, this.txContext);
    }

    @Override
    public void removeArtifact(IArtifact artifact) {
        this.model.removeArtifact(artifact, this.txContext);
    }
}

