/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.TypeArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IType;

public class TypeReference
extends AbstractArtifactReference
implements IArtifactReference,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile transient int hashCode = 0;
    private final IProject project;
    private final String typeName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeReference(IArtifact owner, IProject project, String typeName, ResourceLocation location, String collectorID) {
        super(new TypeArtifactLocator(typeName, project), owner);
        this.addLocation(new ArtifactReferenceLocation(location, true, collectorID));
        this.typeName = typeName;
        this.project = project;
        TypeArtifact ta = (TypeArtifact)this.getLocator().locateArtifact();
        if (ta != null) {
            TypeArtifact typeArtifact = ta;
            synchronized (typeArtifact) {
                ta.incrementReferenceCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(ITransactionContext txContext) {
        TypeArtifact ta = (TypeArtifact)this.getLocator().locateArtifact();
        if (ta != null) {
            TypeArtifact typeArtifact = ta;
            synchronized (typeArtifact) {
                ta.decrementReferenceCount();
                if (ta.hasZeroReferences()) {
                    DependencyModelManager.getInstance().getModel().removeArtifact(ta, txContext);
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public String getType() {
        return "type";
    }

    @Override
    public boolean isMissing() {
        return this.getTargetArtifact().isMissing();
    }

    public IType getJavaType() {
        return ClassUtil.getType((String)this.typeName, (IProject)this.project);
    }

    @Override
    protected IArtifact createMissingArtifact() {
        return new TypeArtifact(this.typeName, this.project);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TypeReference) {
            boolean projectIsEqual;
            boolean typeNameIsEqual;
            TypeReference otherRef = (TypeReference)object;
            if (this.typeName != null) {
                typeNameIsEqual = this.typeName.equals(otherRef.typeName);
            } else {
                boolean bl = typeNameIsEqual = otherRef.typeName == null;
            }
            if (this.project != null) {
                projectIsEqual = this.project.equals((Object)otherRef.project);
            } else {
                boolean bl = projectIsEqual = otherRef.project == null;
            }
            return super.equals(object) && typeNameIsEqual && projectIsEqual;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash(this.typeName);
            hcu.hash(this.project);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput(out);
        su.writeResource((IResource)this.project);
        out.writeObject(this.typeName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, PrivilegedActionException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput(in);
        su.readFinalProjectFromStream(this, "project");
        su.readFinalFieldFromStream(this, "typeName", String.class);
    }

    @Override
    public String toString() {
        return "type-reference[" + this.project.getName() + "/" + this.typeName + "]";
    }

    private static final class TypeArtifactLocator
    implements IArtifactLocator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final IProject project;
        private final String typeName;
        private volatile transient int hashCode = 0;

        public TypeArtifactLocator(String typeName, IProject project) {
            this.typeName = typeName;
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IArtifact locateArtifact() {
            IDependencyModel model = DependencyModelManager.getInstance().getModel();
            ResourceArtifact owner = model.ensureResourceArtifact((IResource)this.project);
            IProject iProject = this.project;
            synchronized (iProject) {
                TypeArtifact typeArtifact = (TypeArtifact)model.queryArtifactsByOwnerNameAndType(owner, this.typeName, "type");
                if (typeArtifact == null) {
                    typeArtifact = new TypeArtifact(this.typeName, this.project);
                    model.addTypeArtifact(typeArtifact);
                }
                return typeArtifact;
            }
        }

        public boolean equals(Object other) {
            if (other instanceof TypeArtifactLocator) {
                TypeArtifactLocator otherTAL = (TypeArtifactLocator)other;
                if (otherTAL.project == this.project) {
                    return this.typeName == null ? otherTAL.typeName == null : this.typeName.equals(otherTAL.typeName);
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                HashCodeUtil hcu = HashCodeUtil.newInstance();
                hcu.hash(this.project);
                hcu.hash(this.typeName);
                this.hashCode = hcu.getHashCode();
            }
            return this.hashCode;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            SerializationUtil su = SerializationUtil.forOutput(out);
            su.writeResource((IResource)this.project);
            out.writeObject(this.typeName);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
            SerializationUtil su = SerializationUtil.forInput(in);
            su.readFinalProjectFromStream(this, "project");
            su.readFinalFieldFromStream(this, "typeName", String.class);
        }
    }
}

