/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.Serializable;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;

public class Range
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long length;
    private final long offset;
    private volatile transient int hashCode = 0;

    public Range(long offset, long length) {
        this.length = length;
        this.offset = offset;
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid length " + length);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Invalid offset " + offset);
        }
        if (length > Long.MAX_VALUE - offset) {
            throw new IllegalArgumentException("Length and offset overflow");
        }
    }

    public long getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getEndOffset() {
        return this.offset + this.length;
    }

    public boolean contains(long anOffset) {
        return this.offset <= anOffset && anOffset < this.offset + this.length;
    }

    public String toString() {
        return String.valueOf(this.offset) + ", " + this.length;
    }

    public boolean equals(Object object) {
        return object instanceof Range && ((Range)object).length == this.length && ((Range)object).offset == this.offset;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(this.length);
            hcu.hash(this.offset);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }
}

