/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.Serializable;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;

public class ArtifactOwnershipReference
extends AbstractArtifactReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String OWNS = "owns";
    private volatile transient int hashCode = 0;

    public static final IArtifactLocator locatorFor(IArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Null Artifact");
        }
        return new ArtifactLocator(artifact);
    }

    public static final IArtifactLocator getLocator(IArtifact artifact) {
        return new ArtifactLocator(artifact);
    }

    public ArtifactOwnershipReference(IArtifact child, IArtifact source) {
        super(ArtifactOwnershipReference.locatorFor(child), source);
        ResourceLocation resLocation = child.getLocation();
        if (resLocation != null) {
            this.addLocation(new ArtifactReferenceLocation(resLocation, true, "OWNERSHIP_REFERENCE_COLLECTOR_ID"));
        }
    }

    @Override
    protected IArtifact createMissingArtifact() {
        return null;
    }

    @Override
    public String getName() {
        return this.getTargetArtifact().getName();
    }

    @Override
    public String getType() {
        return OWNS;
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public boolean isTargetDefinedByReferringSource() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ArtifactOwnershipReference) {
            return super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private static final class ArtifactLocator
    implements IArtifactLocator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final IArtifact artifact;
        private volatile transient int hashCode = 0;

        public ArtifactLocator(IArtifact artifact) {
            this.artifact = artifact;
        }

        @Override
        public IArtifact locateArtifact() {
            return this.artifact;
        }

        public boolean equals(Object other) {
            return other instanceof ArtifactLocator ? this.artifact.equals(((ArtifactLocator)other).artifact) : false;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                HashCodeUtil hcu = HashCodeUtil.newInstance();
                hcu.hash(this.locateArtifact());
                this.hashCode = hcu.getHashCode();
            }
            return this.hashCode;
        }
    }
}

