/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.dependency.artifact;

import java.io.Serializable;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public abstract class AbstractVirtualArtifact
extends AbstractArtifact
implements IVirtualArtifact,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String collectorID;
    private final ResourceLocation boundedLocation;
    private volatile transient int hashCode = 0;

    protected AbstractVirtualArtifact(ResourceLocation location, ResourceLocation boundedLocation, String collectorID) {
        super(location);
        this.boundedLocation = boundedLocation;
        this.collectorID = collectorID;
    }

    @Override
    public String getCollectorID() {
        return this.collectorID;
    }

    @Override
    public IProject getProject() {
        ResourceLocation loc = this.getLocation();
        return loc == null ? null : loc.getResource().getProject();
    }

    @Override
    public ResourceLocation getBoundedLocation() {
        return this.boundedLocation;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AbstractVirtualArtifact) {
            AbstractVirtualArtifact otherAVA = (AbstractVirtualArtifact)other;
            String collectorID = this.getCollectorID();
            return super.equals(other) && (collectorID == null ? otherAVA.getCollectorID() == null : collectorID.equals(otherAVA.getCollectorID()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash(this.getCollectorID());
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    @Override
    public IResource[] getAffectedResources() {
        return this.getOwner().getAffectedResources();
    }
}

