/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.concurrency.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.concurrency.PreLockCommand;
import oracle.eclipse.tools.common.services.concurrency.internal.ConcurrencyCommandBuilder;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class ConcurrencyCommandExtensionReader {
    public static final String EXT_PT = "concurrencyCommand";
    private static final List<ConcurrencyCommandBuilder> sPRE_LOCK_COMMANDS;

    static {
        ArrayList<ConcurrencyCommandBuilder> commands = new ArrayList<ConcurrencyCommandBuilder>(5);
        try {
            Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.common.services", (String)EXT_PT);
            block3: for (IExtension extension : extensions) {
                IConfigurationElement[] elems;
                IConfigurationElement[] iConfigurationElementArray = elems = extension.getConfigurationElements();
                int n = elems.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement commandElem = iConfigurationElementArray[n2];
                    ConcurrencyCommandBuilder builder = new ConcurrencyCommandBuilder(commandElem.getContributor().getName());
                    IConfigurationElement commandClassElement = PluginUtil.findOptionalElement((IConfigurationElement)commandElem, (String)"command-class");
                    IConfigurationElement commandFactoryElement = null;
                    if (commandClassElement == null) {
                        commandFactoryElement = PluginUtil.findOptionalElement((IConfigurationElement)commandElem, (String)"command-factory");
                        if (commandFactoryElement == null) {
                            PluginUtil.reportInvalildElement((IExtension)extension, (IConfigurationElement)commandElem);
                            continue block3;
                        }
                        builder.setCommandFactoryClass(PluginUtil.findRequiredAttribute((IConfigurationElement)commandFactoryElement, (String)"factory-class"));
                    } else {
                        builder.setCommandClass(PluginUtil.findRequiredAttribute((IConfigurationElement)commandClassElement, (String)"class-name"));
                    }
                    IConfigurationElement enablementElement = PluginUtil.findOptionalElement((IConfigurationElement)commandElem, (String)"enablement");
                    Expression expression = null;
                    if (enablementElement != null) {
                        expression = ExpressionConverter.getDefault().perform(enablementElement);
                        builder.setEnablementExpression(expression);
                    }
                    commands.add(builder);
                    ++n2;
                }
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
        }
        catch (PluginUtil.InvalidExtensionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        sPRE_LOCK_COMMANDS = Collections.unmodifiableList(commands);
    }

    public static Set<PreLockCommand> getCommands(IProject project) {
        LinkedHashSet<PreLockCommand> participants = new LinkedHashSet<PreLockCommand>(sPRE_LOCK_COMMANDS.size());
        for (ConcurrencyCommandBuilder builder : sPRE_LOCK_COMMANDS) {
            try {
                PreLockCommand command;
                if (!builder.isEnabledFor(project) || (command = builder.build()) == null) continue;
                participants.add(command);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
            }
        }
        return participants;
    }
}

