/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.catalogue;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.eclipse.tools.common.services.catalogue.Catalogue;
import oracle.eclipse.tools.common.services.catalogue.CatalogueIndex;

public class ThreadSafeCatalogue
extends Catalogue {
    private final Catalogue _delegate;
    protected final ReadWriteLock _lock;

    public ThreadSafeCatalogue(Catalogue catalogue) {
        this(catalogue, new ReentrantReadWriteLock());
    }

    public ThreadSafeCatalogue(Catalogue catalogue, ReadWriteLock lock) {
        this._delegate = catalogue;
        this._lock = lock;
    }

    @Override
    public void addIndex(final CatalogueIndex index) {
        this.executeWriteLockedNoReturn(new Runnable(){

            @Override
            public void run() {
                ThreadSafeCatalogue.this._delegate.addIndex(index);
            }
        });
    }

    @Override
    public CatalogueIndex getIndex(final String srcId, final String id) {
        return this.executeReadLocked(new RunnableWithReturn<CatalogueIndex>(){

            @Override
            public CatalogueIndex run() {
                return ThreadSafeCatalogue.this._delegate.getIndex(srcId, id);
            }
        });
    }

    @Override
    public Map<String, ? extends CatalogueIndex> getIndices(final String srcId) {
        return this.executeReadLocked(new RunnableWithReturn<Map<String, ? extends CatalogueIndex>>(){

            @Override
            public Map<String, ? extends CatalogueIndex> run() {
                return ThreadSafeCatalogue.this._delegate.getIndices(srcId);
            }
        });
    }

    @Override
    public CatalogueIndex findByKey(final String key) {
        return this.executeReadLocked(new RunnableWithReturn<CatalogueIndex>(){

            @Override
            public CatalogueIndex run() {
                return ThreadSafeCatalogue.this._delegate.findByKey(key);
            }
        });
    }

    @Override
    public int size() {
        return this.executeReadLocked(new RunnableWithReturn<Integer>(){

            @Override
            public Integer run() {
                return ThreadSafeCatalogue.this._delegate.size();
            }
        });
    }

    public int hashCode() {
        return this.executeReadLocked(new RunnableWithReturn<Integer>(){

            @Override
            public Integer run() {
                return ThreadSafeCatalogue.this._delegate.hashCode();
            }
        });
    }

    public boolean equals(final Object obj) {
        return this.executeReadLocked(new RunnableWithReturn<Boolean>(){

            @Override
            public Boolean run() {
                return ThreadSafeCatalogue.this._delegate.equals(obj);
            }
        });
    }

    public void executeWriteLockedNoReturn(Runnable runnable) {
        boolean isLocked = false;
        try {
            try {
                isLocked = this._lock.writeLock().tryLock(60L, TimeUnit.SECONDS);
                if (isLocked) {
                    runnable.run();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (isLocked) {
                this._lock.writeLock().unlock();
            }
        }
    }

    public <T> T executeReadLocked(RunnableWithReturn<T> runnable) {
        boolean isLocked = false;
        try {
            isLocked = this._lock.readLock().tryLock(60L, TimeUnit.SECONDS);
            if (isLocked) {
                T t = runnable.run();
                return t;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (isLocked) {
                this._lock.readLock().unlock();
            }
        }
        return null;
    }

    public static abstract class RunnableWithReturn<T> {
        public abstract T run();
    }
}

