/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.merge;

import oracle.eclipse.tools.common.services.appgen.Messages;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.merge.IMerger;
import oracle.eclipse.tools.common.services.appgen.resulthandling.IResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public abstract class AppgenFileMerge
implements IMerger {
    @Override
    public String merge(IResult result) throws GenerationException {
        IFile file = result.getContext().getTargetFile();
        if (file == null) {
            throw new GenerationException(Messages.Merging_process_failed_null_file);
        }
        return this.merge(file, result.getContent());
    }

    public abstract String merge(IFile var1, String var2) throws GenerationException;

    public boolean matches(IFile file) throws GenerationException {
        if (!file.exists()) {
            return false;
        }
        return this.hasContentTypeId(file);
    }

    protected abstract boolean hasContentTypeId(IFile var1) throws GenerationException;

    protected String getFileContentTypeId(IFile file) {
        try {
            IContentType contentType;
            IContentDescription desc = file.getContentDescription();
            if (desc != null && (contentType = desc.getContentType()) != null) {
                return contentType.getId();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

