/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.appgen.generators;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContext;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContextFactory;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationParticipant;

public class CompositeGenerationContextFactory
implements IGenerationContextFactory {
    private final List<IGenerationContextFactory> contextFactories = new ArrayList<IGenerationContextFactory>();

    public void add(IGenerationContextFactory generationContextFactory) {
        if (generationContextFactory != null) {
            this.contextFactories.add(generationContextFactory);
        }
    }

    @Override
    public List<IGenerationContext> getGenerationContexts() throws GenerationException {
        ArrayList<IGenerationContext> genContexts = new ArrayList<IGenerationContext>();
        for (IGenerationContextFactory factory : this.contextFactories) {
            List<IGenerationContext> contexts = factory.getGenerationContexts();
            if (contexts == null) continue;
            genContexts.addAll(contexts);
        }
        return genContexts;
    }

    @Override
    public List<IGenerationParticipant> getGenerationParticipants() {
        ArrayList<IGenerationParticipant> genParticipants = new ArrayList<IGenerationParticipant>();
        for (IGenerationContextFactory factory : this.contextFactories) {
            List<IGenerationParticipant> participants = factory.getGenerationParticipants();
            if (participants == null) continue;
            genParticipants.addAll(participants);
        }
        return genParticipants;
    }
}

