/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services;

import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class SpecialPreferenceManager {
    private static final String KEY_ORACLE_ECLIPSE_TOOLS_WEBTIER_MODELMANAGER_TIMEOUT_OVERRIDE = "oracle.eclipse.tools.webtier.modelmanager.timeout.override";
    private static final String KEY_MODELMANAGER_MAX_WAIT_DURING_CONCURRENT_LOAD = "modelmanager.maxWaitDuringConcurrentLoad";
    private static final int MODELMANAGER_MAX_WAIT_NOT_SET = -1;
    private static final int DEFAULT_DEADLOCK_TIMEOUT_MS = 30000;
    private Integer _oldDeadlockValue;

    void doStartActions() {
        this.setDeadlockTimeoutIfNotSet(30000, new SystemPropertyProxy());
    }

    void doStopActions() {
        this.unsetModelManagerDeadlockTimeout();
    }

    protected final void setDeadlockTimeoutIfNotSet(int numMs, SystemPropertyProxy systemPropertyProxy) {
        String useValueStr = systemPropertyProxy.getProperty(KEY_ORACLE_ECLIPSE_TOOLS_WEBTIER_MODELMANAGER_TIMEOUT_OVERRIDE);
        if (useValueStr == null) {
            useValueStr = systemPropertyProxy.getEnvVariable(KEY_ORACLE_ECLIPSE_TOOLS_WEBTIER_MODELMANAGER_TIMEOUT_OVERRIDE);
        }
        int useValue = numMs;
        if (useValueStr != null) {
            try {
                useValue = Integer.parseInt(useValueStr);
            }
            catch (NumberFormatException numberFormatException) {
                LoggingService.logInfo((Plugin)Activator.getDefault(), (String)("Bad value in system property for model manager timeout. Value: " + useValueStr));
            }
        }
        this._oldDeadlockValue = this.getDeadlockTimeout();
        if (!this.setDeadlockTimeout(useValue)) {
            this._oldDeadlockValue = null;
            LoggingService.logInfo((Plugin)Activator.getDefault(), (String)("Failed to SET OEPE value for ModelManager deadlock timeout.  The current value is: " + this._oldDeadlockValue));
        }
    }

    protected final void unsetModelManagerDeadlockTimeout() {
        if (this._oldDeadlockValue != null) {
            if (!this.setDeadlockTimeout(this._oldDeadlockValue)) {
                LoggingService.logInfo((Plugin)Activator.getDefault(), (String)"Failed to UNSET OEPE value for ModelManager deadlock timeout.");
            }
            this._oldDeadlockValue = null;
        }
    }

    protected final Integer getOldValue() {
        return this._oldDeadlockValue;
    }

    private int getDeadlockTimeout() {
        IEclipsePreferences instancePrefs = InstanceScope.INSTANCE.getNode("org.eclipse.wst.sse.core");
        return instancePrefs.getInt(KEY_MODELMANAGER_MAX_WAIT_DURING_CONCURRENT_LOAD, -1);
    }

    private boolean setDeadlockTimeout(int numMs) {
        IEclipsePreferences instancePrefs = InstanceScope.INSTANCE.getNode("org.eclipse.wst.sse.core");
        if (numMs == -1) {
            instancePrefs.remove(KEY_MODELMANAGER_MAX_WAIT_DURING_CONCURRENT_LOAD);
        } else {
            instancePrefs.putInt(KEY_MODELMANAGER_MAX_WAIT_DURING_CONCURRENT_LOAD, numMs);
        }
        try {
            instancePrefs.flush();
            return true;
        }
        catch (BackingStoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            return false;
        }
    }

    public static class SystemPropertyProxy {
        public String getProperty(String key) {
            return System.getProperty(key);
        }

        public String getEnvVariable(String key) {
            return System.getenv(key);
        }
    }
}

