/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services;

import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class Preferences {
    public static final String COLLECTION_PREFERENCE_KEY = "oracle.eclipse.tools.common.services:collection.enablement:";
    public static final String DISCOVERY_PREFERENCE_KEY = "oracle.eclipse.tools.common.services:discovery.enablement:";
    public static final String OVERRIDE_KEY = "oracle.eclipse.tools.common.services:project.override";
    public static final String DISABLE_KEY = "oracle.eclipse.tools.common.services:disable";
    public static final String DOT_FILE_KEY = "oracle.eclipse.tools.common.services:ignore.system.files";
    private static final IScopeContext defaultScope = DefaultScope.INSTANCE;
    private static final IScopeContext instanceScope = InstanceScope.INSTANCE;
    private static final IScopeContext[] prefScopes = new IScopeContext[]{instanceScope, defaultScope};
    protected final IPreferencesService pService;

    public Preferences(IPreferencesService pService) {
        this.pService = pService;
    }

    public void initDefaults() {
        IEclipsePreferences defaultNode = defaultScope.getNode("oracle.eclipse.tools.common.services");
        defaultNode.putBoolean(OVERRIDE_KEY, true);
        defaultNode.putBoolean(DISABLE_KEY, false);
        defaultNode.putBoolean(DOT_FILE_KEY, true);
        IConfigurationElement[] configElems = Platform.getExtensionRegistry().getConfigurationElementsFor("oracle.eclipse.tools.common.services.TechnologyExtension");
        int i = 0;
        while (i < configElems.length) {
            AbstractTechnologyDiscoveryProvider.TechnologyExtensionIdentifier ite = new AbstractTechnologyDiscoveryProvider.TechnologyExtensionIdentifier(configElems[i]);
            defaultNode.putBoolean(this.getDiscoveryKey(ite), true);
            defaultNode.putBoolean(this.getCollectionKey(ite), true);
            ++i;
        }
        try {
            defaultNode.flush();
        }
        catch (BackingStoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
    }

    public boolean isTechnologyExtensionActiveForCollection(String techId, String techVersion) {
        return this.pService.getBoolean("oracle.eclipse.tools.common.services", COLLECTION_PREFERENCE_KEY + techId + techVersion, true, prefScopes);
    }

    public void setTechnologyExtensionActiveForCollection(String techId, String techVersion, boolean active) {
        this.setPreference(COLLECTION_PREFERENCE_KEY + techId + techVersion, active, prefScopes);
    }

    public boolean isTechnologyExtensionActiveForDiscovery(String techId, String techVersion) {
        return this.pService.getBoolean("oracle.eclipse.tools.common.services", DISCOVERY_PREFERENCE_KEY + techId + techVersion, true, prefScopes);
    }

    public void setTechnologyExtensionActiveForDiscovery(String techId, String techVersion, boolean active) {
        this.setPreference(DISCOVERY_PREFERENCE_KEY + techId + techVersion, active, prefScopes);
    }

    public boolean isIgnoreSystemFilePreference() {
        return this.pService.getBoolean("oracle.eclipse.tools.common.services", DOT_FILE_KEY, true, prefScopes);
    }

    public void setIgnoreSystemFilePreference(boolean ignore) {
        this.setPreference(DOT_FILE_KEY, ignore, prefScopes);
    }

    public boolean isProjectSpecificSettingAllowed() {
        return this.pService.getBoolean("oracle.eclipse.tools.common.services", OVERRIDE_KEY, true, prefScopes);
    }

    public void setProjectSpecificSettingAllowed(boolean allowed) {
        this.setPreference(OVERRIDE_KEY, allowed, prefScopes);
    }

    public boolean isDisabled() {
        return this.pService.getBoolean("oracle.eclipse.tools.common.services", DISABLE_KEY, false, prefScopes);
    }

    public void setDisabled(boolean disabled) {
        this.setPreference(DISABLE_KEY, disabled, prefScopes);
    }

    protected void setPreference(String key, boolean value, IScopeContext[] prefScopes) {
        IEclipsePreferences prefNode = prefScopes[0].getNode("oracle.eclipse.tools.common.services");
        boolean removeNode = true;
        int i = 1;
        while (i < prefScopes.length) {
            if (value != prefScopes[i].getNode("oracle.eclipse.tools.common.services").getBoolean(key, true)) {
                removeNode = false;
                break;
            }
            ++i;
        }
        if (removeNode) {
            prefNode.remove(key);
        } else {
            prefNode.putBoolean(key, value);
        }
    }

    protected String getDiscoveryKey(ITechnologyExtensionIdentifier ite) {
        return DISCOVERY_PREFERENCE_KEY + ite.getId() + ite.getVersion();
    }

    protected String getCollectionKey(ITechnologyExtensionIdentifier ite) {
        return COLLECTION_PREFERENCE_KEY + ite.getId() + ite.getVersion();
    }

    public final void resetToDefaultTechnologyExtensionActiveForDiscovery(String id, String version) {
        IEclipsePreferences defaultNode = defaultScope.getNode("oracle.eclipse.tools.common.services");
        boolean defaultValue = defaultNode.getBoolean(DISCOVERY_PREFERENCE_KEY + id + version, true);
        this.setTechnologyExtensionActiveForDiscovery(id, version, defaultValue);
    }

    public final void resetToDefaultTechnologyExtensionActiveForCollection(String id, String version) {
        IEclipsePreferences defaultNode = defaultScope.getNode("oracle.eclipse.tools.common.services");
        boolean defaultValue = defaultNode.getBoolean(COLLECTION_PREFERENCE_KEY + id + version, true);
        this.setTechnologyExtensionActiveForCollection(id, version, defaultValue);
    }

    public final void resetToDefaultProjectSpecificSettingAllowed() {
        IEclipsePreferences defaultNode = defaultScope.getNode("oracle.eclipse.tools.common.services");
        boolean defaultValue = defaultNode.getBoolean(OVERRIDE_KEY, true);
        this.setProjectSpecificSettingAllowed(defaultValue);
    }

    public final void resetToDefaultDisabled() {
        IEclipsePreferences defaultNode = defaultScope.getNode("oracle.eclipse.tools.common.services");
        boolean defaultValue = defaultNode.getBoolean(DISABLE_KEY, false);
        this.setDisabled(defaultValue);
    }

    public final void resetToDefaultIgnoreSystemFilePreference() {
        IEclipsePreferences defaultNode = defaultScope.getNode("oracle.eclipse.tools.common.services");
        boolean defaultValue = defaultNode.getBoolean(DOT_FILE_KEY, true);
        this.setIgnoreSystemFilePreference(defaultValue);
    }

    public boolean flush() {
        return this.flush(prefScopes);
    }

    protected boolean flush(IScopeContext[] prefScopes) {
        try {
            int i = 0;
            while (i < prefScopes.length - 1) {
                prefScopes[i].getNode("oracle.eclipse.tools.common.services").flush();
                ++i;
            }
        }
        catch (BackingStoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
            return false;
        }
        return true;
    }

    public Preferences getProjectPreferences(IProject project) {
        return new ProjectPreferences(project, this.pService);
    }

    private static final class ProjectPreferences
    extends Preferences {
        private final IScopeContext[] projectPrefScopes;

        public ProjectPreferences(IProject project, IPreferencesService pService) {
            super(pService);
            this.projectPrefScopes = new IScopeContext[]{new ProjectScope(project), instanceScope, defaultScope};
        }

        @Override
        public boolean isTechnologyExtensionActiveForCollection(String techId, String techVersion) {
            if (super.isProjectSpecificSettingAllowed()) {
                return this.pService.getBoolean("oracle.eclipse.tools.common.services", Preferences.COLLECTION_PREFERENCE_KEY + techId + techVersion, true, this.projectPrefScopes);
            }
            return super.isTechnologyExtensionActiveForCollection(techId, techVersion);
        }

        @Override
        public void setTechnologyExtensionActiveForCollection(String techId, String techVersion, boolean active) {
            this.setPreference(Preferences.COLLECTION_PREFERENCE_KEY + techId + techVersion, active, this.projectPrefScopes);
        }

        @Override
        public boolean isTechnologyExtensionActiveForDiscovery(String techId, String techVersion) {
            if (super.isProjectSpecificSettingAllowed()) {
                return this.pService.getBoolean("oracle.eclipse.tools.common.services", Preferences.DISCOVERY_PREFERENCE_KEY + techId + techVersion, true, this.projectPrefScopes);
            }
            return super.isTechnologyExtensionActiveForDiscovery(techId, techVersion);
        }

        @Override
        public void setTechnologyExtensionActiveForDiscovery(String techId, String techVersion, boolean active) {
            this.setPreference(Preferences.DISCOVERY_PREFERENCE_KEY + techId + techVersion, active, this.projectPrefScopes);
        }

        @Override
        public boolean isIgnoreSystemFilePreference() {
            if (super.isProjectSpecificSettingAllowed()) {
                return this.pService.getBoolean("oracle.eclipse.tools.common.services", Preferences.DOT_FILE_KEY, true, this.projectPrefScopes);
            }
            return super.isIgnoreSystemFilePreference();
        }

        @Override
        public void setIgnoreSystemFilePreference(boolean ignore) {
            this.setPreference(Preferences.DOT_FILE_KEY, ignore, this.projectPrefScopes);
        }

        @Override
        public boolean isDisabled() {
            if (super.isProjectSpecificSettingAllowed()) {
                return this.pService.getBoolean("oracle.eclipse.tools.common.services", Preferences.DISABLE_KEY, false, this.projectPrefScopes);
            }
            return super.isDisabled();
        }

        @Override
        public void setDisabled(boolean disabled) {
            this.setPreference(Preferences.DISABLE_KEY, disabled, this.projectPrefScopes);
        }

        @Override
        public boolean flush() {
            return this.flush(this.projectPrefScopes);
        }
    }
}

