/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.ui.internal.widgets.FormWidgetFactory;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.DoublePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.JpaFileModel;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.ResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.editors.JpaEditorPageDefinition;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaXmlEditor
extends FormEditor {
    private final ModifiablePropertyValueModel<IFileEditorInput> editorInputModel = new SimplePropertyValueModel();
    private PropertyValueModel<JpaStructureNode> rootStructureNodeModel;
    private final PropertyChangeListener rootStructureNodeListener = new RootStructureNodeListener();
    private ModifiablePropertyValueModel<JpaStructureNode> pageRootStructureNodeModel;
    private final StructuredTextEditor structuredTextEditor = new StructuredTextEditor();
    ResourceManager resourceManager;
    WidgetFactory widgetFactory;
    private static final Transformer<IFileEditorInput, PropertyValueModel<JpaFile>> JPA_FILE_MODEL_TRANSFORMER = new JpaFileModelTransformer();

    public JpaXmlEditor() {
        this.structuredTextEditor.setEditorPart((IEditorPart)this);
    }

    protected FormToolkit createToolkit(Display display) {
        FormToolkit toolkit = super.createToolkit(display);
        this.resourceManager = this.buildResourceManager();
        this.widgetFactory = new FormWidgetFactory(toolkit);
        return toolkit;
    }

    private ResourceManager buildResourceManager() {
        JpaWorkbench jpaWorkbench = this.getJpaWorkbench();
        return jpaWorkbench != null ? jpaWorkbench.buildLocalResourceManager() : new LocalResourceManager(JFaceResources.getResources((Display)this.getWorkbench().getDisplay()));
    }

    private JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)PlatformTools.getAdapter((Object)this.getWorkbench(), JpaWorkbench.class);
    }

    private IWorkbench getWorkbench() {
        return this.getSite().getWorkbenchWindow().getWorkbench();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        Assert.isLegal((boolean)(editorInput instanceof IFileEditorInput), (String)"Invalid Input: Must be IFileEditorInput");
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
        this.rootStructureNodeModel = this.buildRootStructureNodeModel();
        this.rootStructureNodeModel.addPropertyChangeListener("value", this.rootStructureNodeListener);
    }

    protected void setInput(IEditorInput editorInput) {
        super.setInput(editorInput);
        this.editorInputModel.setValue((Object)((IFileEditorInput)editorInput));
    }

    protected void setInputWithNotify(IEditorInput editorInput) {
        super.setInputWithNotify(editorInput);
        this.editorInputModel.setValue((Object)((IFileEditorInput)editorInput));
    }

    protected void addPages() {
        this.addXMLSourceEditorPage();
        if (this.rootStructureNodeModel.getValue() != null) {
            this.setPageRootStructureNode_((JpaStructureNode)this.rootStructureNodeModel.getValue());
            this.setActivePage(0);
        }
    }

    private void addXMLSourceEditorPage() {
        try {
            int index = this.addPage((IEditorPart)this.structuredTextEditor, (IEditorInput)this.getEditorInput());
            this.setPageText(index, JptJpaUiMessages.JPA_XML_EDITOR_SOURCE_PAGE);
        }
        catch (PartInitException e) {
            JptJpaUiPlugin.instance().logError(e);
        }
    }

    private void addSpecificPages(PropertyValueModel<JpaStructureNode> structureNodeModel) {
        JpaStructureNode rootStructureNode = (JpaStructureNode)structureNodeModel.getValue();
        JptResourceType resourceType = rootStructureNode.getResourceType();
        if (resourceType == null) {
            return;
        }
        JpaPlatform jpaPlatform = rootStructureNode.getJpaPlatform();
        JpaPlatformUi jpaPlatformUI = (JpaPlatformUi)jpaPlatform.getAdapter(JpaPlatformUi.class);
        if (jpaPlatformUI == null) {
            return;
        }
        ResourceUiDefinition definition = jpaPlatformUI.getResourceUiDefinition(resourceType);
        ListIterable<JpaEditorPageDefinition> pageDefinitions = definition.getEditorPageDefinitions();
        for (JpaEditorPageDefinition editorPageDefinition : pageDefinitions) {
            Page formPage = new Page(editorPageDefinition, structureNodeModel);
            int index = this.getPageCount() == 0 ? 0 : this.getPageCount() - 1;
            try {
                this.addPage(index, (IFormPage)formPage);
            }
            catch (PartInitException e) {
                JptJpaUiPlugin.instance().logError(e);
            }
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return editor == this.structuredTextEditor ? new Site((MultiPageEditorPart)this, editor) : super.createSite(editor);
    }

    public Object getAdapter(Class adapterClass) {
        Object adapter = super.getAdapter(adapterClass);
        return adapter != null ? adapter : this.structuredTextEditor.getAdapter(adapterClass);
    }

    public void doSave(IProgressMonitor monitor) {
        this.structuredTextEditor.doSave(monitor);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    private PropertyValueModel<JpaFile> buildJpaFileModel() {
        return new DoublePropertyValueModel(this.buildJpaFileModelModel());
    }

    private PropertyValueModel<PropertyValueModel<JpaFile>> buildJpaFileModelModel() {
        return new TransformationPropertyValueModel(this.editorInputModel, JPA_FILE_MODEL_TRANSFORMER);
    }

    void setPageRootStructureNode(JpaStructureNode jpaStructureNode) {
        this.execute(new SetPageRootStructureNodeRunnable(jpaStructureNode));
    }

    void setPageRootStructureNode_(JpaStructureNode rootStructureNode) {
        if (this.pageRootStructureNodeModel != null) {
            this.pageRootStructureNodeModel.setValue(null);
            this.pageRootStructureNodeModel = null;
        }
        if (this.getPageCount() > 1) {
            this.setActivePage(this.getPageCount() - 1);
            while (this.getPageCount() > 1) {
                this.removePage(0);
            }
        }
        if (rootStructureNode != null) {
            this.pageRootStructureNodeModel = new SimplePropertyValueModel((Object)rootStructureNode);
            this.addSpecificPages((PropertyValueModel<JpaStructureNode>)this.pageRootStructureNodeModel);
        }
    }

    private PropertyValueModel<JpaStructureNode> buildRootStructureNodeModel() {
        return new RootStructureNodeModel(this.buildRootStructureNodesCollectionModel());
    }

    private CollectionValueModel<JpaStructureNode> buildRootStructureNodesCollectionModel() {
        return new RootStructureNodesCollectionModel(this.buildJpaFileModel());
    }

    public void dispose() {
        this.editorInputModel.setValue(null);
        this.rootStructureNodeModel.removePropertyChangeListener("value", this.rootStructureNodeListener);
        this.widgetFactory.dispose();
        this.resourceManager.dispose();
        super.dispose();
    }

    public IFileEditorInput getEditorInput() {
        return (IFileEditorInput)super.getEditorInput();
    }

    private void execute(Runnable runnable) {
        DisplayTools.execute((Display)this.getSite().getShell().getDisplay(), (Runnable)runnable);
    }

    public String toString() {
        return ObjectTools.toString((Object)((Object)this), (Object)((IFileEditorInput)this.editorInputModel.getValue()).getFile());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaFileModelTransformer
    extends AbstractTransformer<IFileEditorInput, PropertyValueModel<JpaFile>> {
        JpaFileModelTransformer() {
        }

        protected PropertyValueModel<JpaFile> transform_(IFileEditorInput fileEditorInput) {
            return (JpaFileModel)fileEditorInput.getFile().getAdapter(JpaFileModel.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Page
    extends FormPage {
        private final JpaEditorPageDefinition editorPageDefinition;
        private final PropertyValueModel<JpaStructureNode> structureNodeModel;

        Page(JpaEditorPageDefinition editorPageDefinition, PropertyValueModel<JpaStructureNode> structureNodeModel) {
            super((FormEditor)JpaXmlEditor.this, editorPageDefinition.getClass().getName(), editorPageDefinition.getTitleText());
            this.editorPageDefinition = editorPageDefinition;
            this.structureNodeModel = structureNodeModel;
        }

        protected void createFormContent(IManagedForm managedForm) {
            ScrolledForm form = managedForm.getForm();
            managedForm.getToolkit().decorateFormHeading(form.getForm());
            this.updateForm(form);
            this.updateBody(managedForm);
            this.updateHelpButton();
            form.updateToolBar();
        }

        private void updateForm(ScrolledForm form) {
            form.setText(this.editorPageDefinition.getTitleText());
            ImageDescriptor imageDescriptor = this.editorPageDefinition.getTitleImageDescriptor();
            if (imageDescriptor != null) {
                form.setImage(JpaXmlEditor.this.resourceManager.createImage(imageDescriptor));
            }
        }

        private void updateBody(IManagedForm form) {
            Composite body = form.getForm().getBody();
            body.setLayout((Layout)new GridLayout(1, true));
            this.editorPageDefinition.buildContent(form, JpaXmlEditor.this.widgetFactory, JpaXmlEditor.this.resourceManager, this.structureNodeModel);
            form.reflow(true);
        }

        private void updateHelpButton() {
            String helpID = this.editorPageDefinition.getHelpID();
            if (helpID != null) {
                this.getManagedForm().getForm().getToolBarManager().add((IAction)new HelpAction(helpID));
            }
        }

        public void dispose() {
            ImageDescriptor imageDescriptor = this.editorPageDefinition.getTitleImageDescriptor();
            if (imageDescriptor != null) {
                JpaXmlEditor.this.resourceManager.destroyImage(imageDescriptor);
            }
            super.dispose();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            StringBuilderTools.appendHashCodeToString((StringBuilder)sb, (Object)((Object)this));
            sb.append('(');
            sb.append(this.editorPageDefinition.getTitleText());
            sb.append(')');
            return sb.toString();
        }

        private class HelpAction
        extends Action {
            final String helpID;

            HelpAction(String helpID) {
                super(JptJpaUiMessages.JPA_XML_EDITOR_PAGE_HELP);
                this.helpID = helpID;
            }

            public ImageDescriptor getImageDescriptor() {
                return WorkbenchTools.getSharedImageDescriptor((String)"IMG_LCL_LINKTO_HELP");
            }

            public void run() {
                BusyIndicator.showWhile((Display)Page.this.getManagedForm().getForm().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        WorkbenchTools.displayHelp((String)HelpAction.this.helpID);
                    }
                });
            }
        }
    }

    class RootStructureNodeListener
    extends PropertyChangeAdapter {
        RootStructureNodeListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JpaXmlEditor.this.setPageRootStructureNode((JpaStructureNode)event.getNewValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RootStructureNodeModel
    extends CollectionPropertyValueModelAdapter<JpaStructureNode, JpaStructureNode> {
        RootStructureNodeModel(CollectionValueModel<? extends JpaStructureNode> collectionModel) {
            super(collectionModel);
        }

        protected JpaStructureNode buildValue() {
            return this.collectionModel.size() > 0 ? (JpaStructureNode)this.collectionModel.iterator().next() : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RootStructureNodesCollectionModel
    extends CollectionAspectAdapter<JpaFile, JpaStructureNode> {
        RootStructureNodesCollectionModel(PropertyValueModel<? extends JpaFile> subjectModel) {
            super(subjectModel, new String[]{"rootStructureNodes"});
        }

        protected Iterable<JpaStructureNode> getIterable() {
            return ((JpaFile)this.subject).getRootStructureNodes();
        }

        protected int size_() {
            return ((JpaFile)this.subject).getRootStructureNodesSize();
        }
    }

    class SetPageRootStructureNodeRunnable
    implements Runnable {
        private final JpaStructureNode jpaStructureNode;

        SetPageRootStructureNodeRunnable(JpaStructureNode jpaStructureNode) {
            this.jpaStructureNode = jpaStructureNode;
        }

        public void run() {
            JpaXmlEditor.this.setPageRootStructureNode_(this.jpaStructureNode);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.jpaStructureNode);
        }
    }

    static class Site
    extends MultiPageEditorSite {
        Site(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
            super(multiPageEditor, editor);
        }

        public String getId() {
            return "org.eclipse.core.runtime.xml.source";
        }
    }
}

