/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details.orm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.node.AbstractNode;
import org.eclipse.jpt.common.utility.node.Node;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.details.orm.JptJpaUiDetailsOrmMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AddGeneratorStateObject
extends AbstractNode {
    private String name;
    private String generatorType;
    private Node.Validator validator;
    private PersistenceUnit pUnit;
    static final String NAME_PROPERTY = "nameProperty";
    static final String GENERATOR_TYPE_PROPERTY = "generatorTypeProperty";

    AddGeneratorStateObject(PersistenceUnit pUnit) {
        super(null);
        this.pUnit = pUnit;
    }

    private void addNameProblemsTo(List<Node.Problem> currentProblems) {
        if (StringTools.isBlank((String)this.name)) {
            currentProblems.add(this.buildProblem(JptJpaUiDetailsOrmMessages.GENERATOR_STATE_OBJECT_NAME_MUST_BE_SPECIFIED, 3));
        } else if (this.names().contains(this.name)) {
            currentProblems.add(this.buildProblem(JptJpaUiDetailsOrmMessages.GENERATOR_STATE_OBJECT_NAME_EXISTS, 2));
        }
    }

    private void addGeneratorTypeProblemsTo(List<Node.Problem> currentProblems) {
        if (StringTools.isBlank((String)this.generatorType)) {
            currentProblems.add(this.buildProblem(JptJpaUiDetailsOrmMessages.GENERATOR_STATE_OBJECT_TYPE_MUST_BE_SPECIFIED, 3));
        }
    }

    protected void addProblemsTo(List<Node.Problem> currentProblems) {
        super.addProblemsTo(currentProblems);
        this.addNameProblemsTo(currentProblems);
        this.addGeneratorTypeProblemsTo(currentProblems);
    }

    private List<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        for (Generator generator : this.pUnit.getGenerators()) {
            String name = generator.getName();
            names.add(name);
        }
        return names;
    }

    protected void checkParent(Node parentNode) {
    }

    public String displayString() {
        return null;
    }

    String getName() {
        return this.name;
    }

    String getGeneratorType() {
        return this.generatorType;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged(NAME_PROPERTY, oldName, newName);
    }

    public void setGeneratorType(String newGeneratorType) {
        String old = this.generatorType;
        this.generatorType = newGeneratorType;
        this.firePropertyChanged(GENERATOR_TYPE_PROPERTY, old, newGeneratorType);
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }
}

