/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyListIterator;
import org.eclipse.jpt.common.utility.internal.node.AbstractNode;
import org.eclipse.jpt.common.utility.node.Node;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedBaseJoinColumn;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJoinColumnStateObject
extends AbstractNode {
    private String columnDefinition;
    private BaseJoinColumn joinColumn;
    private String name;
    private Object owner;
    private String referencedColumnName;
    private String table;
    private Node.Validator validator;
    public static final String COLUMN_DEFINITION_PROPERTY = "columnDefinition";
    public static final String NAME_PROPERTY = "name";
    public static final String NAMES_LIST = "names";
    public static final String REFERENCE_COLUMN_NAMES_LIST = "referenceColumnNames";
    public static final String REFERENCED_COLUMN_NAME_PROPERTY = "referencedColumnName";
    public static final String TABLE_PROPERTY = "table";

    public BaseJoinColumnStateObject(Object owner, BaseJoinColumn joinColumn) {
        super(null);
        this.initialize(owner, joinColumn);
    }

    protected final void checkParent(Node parentNode) {
    }

    private static ListIterator<String> columnNames(Table table) {
        if (table == null) {
            return EmptyListIterator.instance();
        }
        return ListTools.list((Iterable)table.getSortedColumnIdentifiers()).listIterator();
    }

    private static int columnsSize(Table table) {
        if (table == null) {
            return 0;
        }
        return table.getColumnsSize();
    }

    public final String displayString() {
        return "";
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public String getDefaultName() {
        return this.joinColumn == null ? null : this.joinColumn.getDefaultName();
    }

    public String getDefaultReferencedColumnName() {
        if (this.joinColumn == null) {
            return null;
        }
        return this.joinColumn.getDefaultReferencedColumnName();
    }

    public abstract String getDefaultTable();

    public BaseJoinColumn getJoinColumn() {
        return this.joinColumn;
    }

    public String getName() {
        return this.name;
    }

    public abstract Table getNameTable();

    public Object getOwner() {
        return this.owner;
    }

    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    public abstract Table getReferencedNameTable();

    public String getTable() {
        return this.table;
    }

    public final Node.Validator getValidator() {
        return this.validator;
    }

    protected void initialize() {
        super.initialize();
        this.validator = NULL_VALIDATOR;
    }

    protected void initialize(Object o, BaseJoinColumn jc) {
        this.owner = o;
        this.joinColumn = jc;
        this.table = this.getInitialTable();
        if (jc != null) {
            this.name = jc.getSpecifiedName();
            this.columnDefinition = jc.getColumnDefinition();
            this.referencedColumnName = jc.getSpecifiedReferencedColumnName();
        }
    }

    protected abstract String getInitialTable();

    public ListIterator<String> names() {
        return BaseJoinColumnStateObject.columnNames(this.getNameTable());
    }

    public int columnsSize() {
        return BaseJoinColumnStateObject.columnsSize(this.getNameTable());
    }

    public ListIterator<String> referenceColumnNames() {
        return BaseJoinColumnStateObject.columnNames(this.getReferencedNameTable());
    }

    public int referenceColumnsSize() {
        return BaseJoinColumnStateObject.columnsSize(this.getReferencedNameTable());
    }

    public void setColumnDefinition(String columnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.firePropertyChanged(COLUMN_DEFINITION_PROPERTY, oldColumnDefinition, columnDefinition);
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, oldName, name);
    }

    public void setReferencedColumnName(String referencedColumnName) {
        String oldReferencedColumnName = this.referencedColumnName;
        this.referencedColumnName = referencedColumnName;
        this.firePropertyChanged(REFERENCED_COLUMN_NAME_PROPERTY, oldReferencedColumnName, referencedColumnName);
    }

    public void setTable(String table) {
        ArrayList oldNames = ListTools.list(this.names());
        ArrayList oldRefColNames = ListTools.list(this.referenceColumnNames());
        String oldTable = this.table;
        this.table = table;
        this.firePropertyChanged(TABLE_PROPERTY, oldTable, table);
        this.synchronizeList(this.names(), oldNames, NAMES_LIST);
        this.synchronizeList(this.referenceColumnNames(), oldRefColNames, REFERENCE_COLUMN_NAMES_LIST);
    }

    public final void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public ListIterator<String> tables() {
        return EmptyListIterator.instance();
    }

    public void updateJoinColumn(SpecifiedBaseJoinColumn jc) {
        if (ObjectTools.notEquals((Object)this.name, (Object)jc.getSpecifiedName())) {
            jc.setSpecifiedName(this.name);
        }
        if (ObjectTools.notEquals((Object)this.referencedColumnName, (Object)jc.getSpecifiedReferencedColumnName())) {
            jc.setSpecifiedReferencedColumnName(this.referencedColumnName);
        }
        if (ObjectTools.notEquals((Object)this.columnDefinition, (Object)jc.getColumnDefinition())) {
            jc.setColumnDefinition(this.columnDefinition);
        }
    }
}

