/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParser
implements Iterator<String> {
    private String val;
    CONTEXT ctx = CONTEXT.FREE;
    private int startIndex = 0;
    private int endIndex = -1;
    private boolean escaped = false;
    private final List<Integer> escapes = new ArrayList<Integer>();
    private String token = null;

    public CommandLineParser(String val) {
        this.val = val;
    }

    @Override
    public String next() {
        String next = this.token;
        if (next == null) {
            throw new RuntimeException("Token not found");
        }
        if (next.startsWith("\"") && next.endsWith("\"")) {
            next = next.substring(1, next.length() - 1);
        }
        this.token = null;
        return next;
    }

    @Override
    public boolean hasNext() {
        boolean ret;
        if (this.token != null) {
            return true;
        }
        boolean next = false;
        this.escapes.clear();
        this.endIndex = this.startIndex;
        while (this.endIndex < this.val.length()) {
            char ch = this.val.charAt(this.endIndex);
            if (ch == ' ') {
                this.escaped = false;
                if (this.ctx == CONTEXT.FREE) {
                    ++this.startIndex;
                } else if (this.ctx == CONTEXT.INSIDE) {
                    this.ctx = CONTEXT.FREE;
                    next = true;
                    break;
                }
            } else if (ch == '\"') {
                if (this.escaped) {
                    this.escapes.add(this.endIndex - this.startIndex - 1);
                    this.escaped = false;
                } else {
                    this.ctx = this.ctx != CONTEXT.INSIDEQUOTE ? CONTEXT.INSIDEQUOTE : CONTEXT.INSIDE;
                }
            } else if (ch == '\\') {
                boolean bl = this.escaped = !this.escaped;
                if (this.ctx == CONTEXT.FREE) {
                    this.ctx = CONTEXT.INSIDE;
                }
            } else {
                this.escaped = false;
                if (this.ctx == CONTEXT.FREE) {
                    this.ctx = CONTEXT.INSIDE;
                }
            }
            ++this.endIndex;
        }
        if (ret = next | (this.endIndex == this.val.length() && this.startIndex != this.endIndex)) {
            this.token = this.nextToken();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextToken() {
        CommandLineParser commandLineParser = this;
        synchronized (commandLineParser) {
            String ret = this.val.substring(this.startIndex, this.endIndex);
            this.startIndex = this.endIndex + 1;
            if (this.escapes.isEmpty()) {
                return ret;
            }
            StringBuffer buf = new StringBuffer();
            int start = 0;
            for (int i = 0; i < this.escapes.size(); ++i) {
                buf.append(ret.substring(start, this.escapes.get(i)));
                start = this.escapes.get(i) + 1;
            }
            buf.append(ret.substring(start, ret.length()));
            return buf.toString();
        }
    }

    public static List<String> parse(String s) {
        ArrayList<String> list = new ArrayList<String>();
        if (s == null) {
            return list;
        }
        CommandLineParser parser = new CommandLineParser(s);
        while (parser.hasNext()) {
            list.add(parser.next());
        }
        return list;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CONTEXT {
        FREE,
        INSIDE,
        INSIDEQUOTE;

    }
}

