/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.clix;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloud.paas.client.cli.command.DescribeJob;
import oracle.cloud.paas.client.clix.jobstatus.JobFailedException;
import oracle.cloud.paas.client.clix.jobstatus.JobPollTimeoutException;
import oracle.cloud.paas.client.clix.jobstatus.JobStatusWaitable;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloud.paas.model.Log;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.TimeUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class CliExtensionUtils
implements ClientConstants {
    public static Date parseDateWithOptionalField(String format, String date) throws ParseException {
        try {
            Date d = new SimpleDateFormat(format).parse(date);
            return CliExtensionUtils.getIntendedDate(d, format);
        }
        catch (ParseException pe) {
            throw new ParseException(pe.getMessage() + " -> format " + format, pe.getErrorOffset());
        }
    }

    public static Date getIntendedDate(Date date, String format) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int month = c.get(2);
        int year = c.get(1);
        int d = c.get(5);
        c.setTime(date);
        if (!format.contains("MM")) {
            c.set(2, month);
        }
        if (!format.contains("dd")) {
            c.set(5, d);
        }
        if (!format.contains("yy")) {
            c.set(1, year);
        }
        return c.getTime();
    }

    public static Job putOnWait(JobStatusWaitable waitable) throws Exception {
        return CliExtensionUtils.putOnWait(waitable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Job putOnWait(JobStatusWaitable waitable, String caption) throws Exception {
        boolean wait = true;
        Date start = new Date();
        String downloadlastlogpath = waitable.getdownloadlastlogpath();
        int pollintervalmillis = waitable.getpollintervalmillis();
        int timeoutsecs = waitable.gettimeoutsecs();
        CommandLine cmd = waitable.getCurrentCommandLine();
        Job job = null;
        while (wait) {
            DescribeJob descJob = null;
            Logger logger = Logger.getDEFAULT();
            synchronized (logger) {
                Logger.getDEFAULT().setCaption(caption);
                descJob = waitable.poll();
                Logger.getDEFAULT().reSetCaption();
            }
            wait = waitable.iswaitfor();
            job = descJob.getCreatedJob();
            List logs = descJob.getApplicationManager().listJobLogs(job.getJobId());
            waitable.setProperty(waitable.getjobstatusproperty(), job.getStatus().toString());
            if (!logs.isEmpty()) {
                waitable.setProperty(waitable.getlastlogproperty(), ((Log)logs.get(logs.size() - 1)).getName());
            }
            if (job.getStatus() == JobStatus.FAILED) {
                wait = false;
                if (waitable.isdownloadlastlogonfailure()) {
                    if (logs.isEmpty()) {
                        throw new Exception("No log files found for job:" + descJob.getJobId());
                    }
                    CommandLine fetchlog = (CommandLine)Main.allCommands.get("job-log-file").simpleClone();
                    for (NameValuePair<String, CommandLineArg> pair : fetchlog.getArgs().getList()) {
                        CommandLineArg arg = pair.getValue();
                        arg.setOptionValue(cmd.getArgValue(arg.getOptionName()));
                    }
                    fetchlog.setValue("jobid", descJob.getJobId());
                    if (downloadlastlogpath != null) {
                        fetchlog.setValue("output", downloadlastlogpath);
                    }
                    fetchlog.setValue("log", ((Log)logs.get(logs.size() - 1)).getName());
                    fetchlog.perform(true);
                }
                throw new JobFailedException("Job failed.");
            }
            if (wait) {
                boolean bl = wait = job.getStatus() != JobStatus.COMPLETE;
            }
            if (!wait) continue;
            if (pollintervalmillis > timeoutsecs * 1000) {
                Logger.getDEFAULT().printlnWarning("Poll interval is more than the timeout value. Resetting poll interval to timeout");
                pollintervalmillis = timeoutsecs * 1000;
            }
            Logger.getDEFAULT().printlnInfo("Current job-status is:" + job.getStatus().toString() + ". Polling for the status for every " + TimeUtils.millisToLongDHMS(pollintervalmillis, true));
            Thread.currentThread();
            Thread.sleep(pollintervalmillis);
            if (timeoutsecs < 0) continue;
            long diff = new Date().getTime() - start.getTime();
            if (diff < (long)(timeoutsecs * 1000)) {
                Logger.getDEFAULT().printlnInfo("Timeout will occur after " + TimeUtils.millisToLongDHMS((long)(timeoutsecs * 1000) - diff, true));
                continue;
            }
            throw new JobPollTimeoutException("Timeout has occurred after " + TimeUtils.millisToLongDHMS(diff, true));
        }
        return job;
    }
}

