/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTShell;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.AbstractWLSTCommand;
import oracle.cloudlogic.javaservice.common.api.service.ApplicationService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.types.ApplicationType;
import oracle.cloudlogic.javaservice.types.CommandType;
import oracle.cloudlogic.javaservice.utils.CommonUtils;

public class AllApplicationsBase
extends AbstractWLSTCommand {
    List<String> applications = null;

    public AllApplicationsBase(WLSTShell wlst) {
        super(wlst);
    }

    @Override
    public void validate() throws CliException {
        try {
            super.validate();
            String application = this.command.getArgValue("application");
            if (application != null) {
                this.applications = CloudUtil.parseString(application);
            }
            if (this.applications == null || this.applications.isEmpty()) {
                this.applications = new ArrayList<String>();
                ApplicationService app = (ApplicationService)this.shell.getServiceManager().getService(ApplicationService.class);
                List list = app.listApplications();
                for (ApplicationType a : list) {
                    this.applications.add(a.getName());
                }
            }
        }
        catch (Exception e) {
            throw new CliException("Error while validating the input.", e);
        }
    }

    @Override
    public void execute() throws Exception {
        if (this.applications.isEmpty()) {
            throw new Exception("No applications found.");
        }
        for (String app : this.applications) {
            CommonUtils.setArg((CommandType)this.cmd, (String)"application", (String)app);
            super.execute();
        }
    }
}

