/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.wlst.cmd.saml;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTShell;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.AbstractWLSTCommand;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.api.service.resource.KeyStoreManagerService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.StringUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.Certificate;
import oracle.cloudlogic.javaservice.types.CommandType;
import oracle.cloudlogic.javaservice.utils.CommonUtils;

public class SetSAMLTrust
extends AbstractWLSTCommand {
    public SetSAMLTrust(WLSTShell wlst) {
        super(wlst);
    }

    @Override
    public void validate() throws CliException {
        CommonUtils.setArg((CommandType)this.cmd, (String)"type", (String)this.command.getArgValue("tokentype"));
        if ("www.oracle.com".equals(this.command.getArgValue("issuer"))) {
            throw new CliException("Read-only Issuer name:" + this.command.getArgValue("issuer"));
        }
        CommonUtils.setArg((CommandType)this.cmd, (String)"issuer", (String)this.command.getArgValue("issuer"));
        String alias = this.command.getArgValue("alias");
        String dn = this.command.getArgValue("trustedDN");
        List<String> aliases = null;
        ArrayList<String> dns = new ArrayList<String>();
        if (alias != null) {
            try {
                aliases = StringUtils.parseWithQuote(alias, ",");
                KeyStoreManagerService res = (KeyStoreManagerService)this.shell.getServiceManager().getService(KeyStoreManagerService.class);
                CertificateService c = res.getDomainLevelTrustService();
                for (String a : aliases) {
                    Certificate cert = c.describeCertificate(a);
                    Logger.getDEFAULT().printlnDebug("Adding dn:" + cert.getDescription().getDn());
                    dns.add(cert.getDescription().getDn());
                }
            }
            catch (ServiceException se) {
                Logger.getDEFAULT().printlnWarning("Unable to resolve aliases into DNs:" + se.getMessage());
                Logger.getDEFAULT().printlnThrowable(se);
            }
        }
        if (dn != null) {
            dns.addAll(StringUtils.parseWithQuote(dn, ","));
        }
        String trustedDNs = CloudUtil.getSeparatedListOfString(dns, "[", "]", true, ",");
        CommonUtils.setArg((CommandType)this.cmd, (String)"trustedDNs", (String)trustedDNs);
    }
}

