/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.wlst;

import java.util.Arrays;
import java.util.Properties;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloud.paas.client.cli.command.HtmlUsagePageGenerator;
import oracle.cloud.paas.client.cli.command.common.wlst.Exit;
import oracle.cloud.paas.client.cli.command.common.wlst.History;
import oracle.cloud.paas.client.cli.command.common.wlst.ListApplications;
import oracle.cloud.paas.client.cli.command.common.wlst.RestartApplication;
import oracle.cloud.paas.client.cli.command.common.wlst.Set;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTExecutorProvider;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTShell;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ListWSSCertificates;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.WLSTConnect;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.WLSTDisconnect;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.saml.DisplaySAMLTrust;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.saml.SetSAMLTrust;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.ListAvailablePolicies;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.client.AttachClientPolicy;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.client.DetachClientPolicy;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.client.DisableClientPolicy;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.client.EnableClientPolicy;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.client.ListClients;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.client.SetClientStubProperty;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service.AttachServicePolicy;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service.DetachServicePolicy;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service.DisableServicePolicy;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service.EnableServicePolicy;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service.ListServices;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service.SetServiceConfiguration;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.ws.service.SetServicePolicyOverride;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.provider.CliExecutorProvider;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;

public class WLSTMain
extends MainBase
implements ClientConstants {
    Properties properties = null;
    public static final OrderedMap<String, CommandLine> allCommands = new OrderedMap();

    public WLSTMain(String defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    @Override
    public OrderedMap<String, CommandLine> getAllCommands() {
        return allCommands;
    }

    public static WLSTMain createWith(WLSTShell shell) throws Exception {
        try {
            CommandLineArg alias = Main.ARG_ALIAS.simpleClone();
            alias.setDescription(NLSUtil.localizeMessage("NLS_PARAM_SAML_TRUSTED_ALIAS", "trustedDN"));
            CommandLineArg token = new CommandLineArg("tokentype", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_SAML_TOKEN_TYPE"));
            token.setShortCut("tt");
            token.setOptionDefaltValue("dns.sv");
            token.setPossibleEnumValues(Arrays.asList("dns.sv", "dns.hok", "dns.jwt"));
            token.setNullStringAllowed(true);
            CommandLineArg issuer = new CommandLineArg("issuer", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_SAML_ISSUER"));
            issuer.setShortCut("is");
            issuer.setOptionDefaltValue("None");
            issuer.setNullStringAllowed(true);
            CommandLineArg dns = new CommandLineArg("trustedDN", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, null, null), NLSUtil.localizeMessage("NLS_PARAM_SAML_TRUSTED_DN", "alias"));
            dns.setShortCut("dns");
            dns.addReplacementOptionName("alias");
            dns.setNullStringAllowed(true);
            CommandLineArg dump = new CommandLineArg("dump", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, ",", null), NLSUtil.localizeMessage("NLS_PARAM_DUMP_HISTORY"));
            dump.setNullStringAllowed(true);
            dump.setShortCut("dmp");
            CommandLineArg module = new CommandLineArg("module", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_MODULE_NAME"));
            module.setShortCut("mod");
            CommandLineArg subject = new CommandLineArg("subject", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_SUBJECT_NAME"));
            subject.setShortCut("sub");
            CommandLineArg target = new CommandLineArg("subject", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_TARGET_NAME"));
            target.setShortCut("sub");
            target.setOptionDefaltValue("server");
            CommandLineArg category = new CommandLineArg("category", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_CATEGORY_NAME"));
            category.setShortCut("cat");
            category.setOptionDefaltValue("security");
            category.setHidden(true);
            CommandLineArg service = new CommandLineArg("service", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_WEB_SERVICE_NAME"));
            service.setShortCut("svc");
            CommandLineArg port = new CommandLineArg("port", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_PORT_NAME"));
            port.setShortCut("prt");
            CommandLineArg policyuris = new CommandLineArg("policyuri", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.many, ",", null), NLSUtil.localizeMessage("NLS_PARAM_POLICY_URI"));
            policyuris.setShortCut("uri");
            CommandLineArg policyuri = new CommandLineArg("policyuri", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, ",", null), NLSUtil.localizeMessage("NLS_PARAM_POLICY_URI"));
            policyuris.setShortCut("uri");
            CommandLineArg props = new CommandLineArg("configprops", true, new CommandLineArg.PropertiesOptionType(), NLSUtil.localizeMessage("NLS_PARAM_CONFIG_PROPERTIES"));
            props.setShortCut("cp");
            CommandLineArg serviceref = new CommandLineArg("serviceref", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_SERVICE_REF"));
            serviceref.setShortCut("ref");
            CommandLineArg clienttype = new CommandLineArg("clienttype", true, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), NLSUtil.localizeMessage("NLS_PARAM_CLIENT_TYPE"));
            clienttype.setShortCut("ct");
            clienttype.setOptionDefaltValue("wsconn");
            props.addPropertyDescription(new CommandLineArg("enable", false, new CommandLineArg.BooleanOptionType(), "Enables or disables the web service endpoint."));
            props.addPropertyDescription(new CommandLineArg("enableTestPage", false, new CommandLineArg.BooleanOptionType(), "Enables or disables the test page for this web service endpoint."));
            props.addPropertyDescription(new CommandLineArg("enableWSDL", false, new CommandLineArg.BooleanOptionType(), "Enables or disables access to the WSDL(Web Service Description Language) document."));
            props.addPropertyDescription(new CommandLineArg("enableREST", false, new CommandLineArg.BooleanOptionType(), "Enables or disables REST access to the web service."));
            props.addPropertyDescription(new CommandLineArg("maxRequestSize", false, new CommandLineArg.NumberOptionType(), "The maximum size of a request that this web service can handle."));
            CommandLineArg overrideprops = new CommandLineArg("overrideprops", true, new CommandLineArg.PropertiesOptionType(), NLSUtil.localizeMessage("NLS_PARAM_OVERRIDE_PROPERTIES"));
            overrideprops.setShortCut("op");
            overrideprops.addPropertyDescription(new CommandLineArg("keystore.sig.csf.key", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "CSF key against which the signing key alias and the key password are stored."));
            overrideprops.addPropertyDescription(new CommandLineArg("keystore.enc.csf.key", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "CSF key against which the encryption key alias and the key password are stored."));
            overrideprops.addPropertyDescription(new CommandLineArg("saml.enveloped.signature.required", false, new CommandLineArg.BooleanOptionType(), "The flag to indicate if the bearer token is signed using the domain signature key.", "saml.enveloped.signature.required", "true"));
            CommandLineArg stubprops = new CommandLineArg("stubprops", true, new CommandLineArg.PropertiesOptionType(), NLSUtil.localizeMessage("NLS_PARAM_CLIENT_STUB_PROPERTIES"));
            stubprops.setShortCut("sp");
            stubprops.addPropertyDescription(new CommandLineArg("oracle.webservices.auth.username", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "The user name to be used in the outbound call. It is recommended to use CSF to store the user and pwd against a csf-key and use the csk-key here. Please see csf-key below."));
            stubprops.addPropertyDescription(new CommandLineArg("oracle.webservices.auth.password", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "The password to be used in the outbound call. It is recommended to use CSF to store the user and pwd against a csf-key and use the csk-key here. Please see csf-key below."));
            stubprops.addPropertyDescription(new CommandLineArg("csf-key", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "The CSF(Credential Store Framework) key used to reference the user and pwd."));
            stubprops.addPropertyDescription(new CommandLineArg("javax.xml.ws.service.endpoint.address", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "Endpoint URL to which the client will send the request."));
            stubprops.addPropertyDescription(new CommandLineArg("saml.issuer.name", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "The SAML token issuer name."));
            stubprops.addPropertyDescription(new CommandLineArg("keystore.enc.csf.key", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "For WSS11 policies, keystore.enc.csf.key is used for asynchronous clients only. For WSS10 policies, keystore.enc.csf.key is used for both asynchronous and synchronous clients."));
            stubprops.addPropertyDescription(new CommandLineArg("keystore.recipient.alias", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "Identifies the public certificate of the service.If the certificate is published in the WSDL, then this is ignored."));
            stubprops.addPropertyDescription(new CommandLineArg("keystore.sig.csf.key", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "Identifies the client key to sign the message."));
            stubprops.addPropertyDescription(new CommandLineArg("javax.xml.ws.session.maintain", false, new CommandLineArg.BooleanOptionType(), "Flag that specifies whether the session should be maintained.\nNote: This property is not available for asynchronous Web service Callback clients."));
            CommandLineArg retain = new CommandLineArg("retain", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_WLST_RETAIN_SESSION"));
            retain.setOptionDefaltValue("false");
            WLSTMain main = new WLSTMain(null);
            main.properties = shell == null ? null : shell.getRuntimeProperties();
            main.setTEST_MODE(true);
            CommandLine command = new CommandLine();
            command.setCommandName("set");
            command.setDescription("sets or removes or prints default values for all arguments supported by various commands in this shell.If an argument is set here, that does not need to be passed on the command line.\nE.g) " + command.getCommandName() + " " + "application" + "=myapp;" + command.getCommandName() + " " + "application" + ";" + command.getCommandName());
            command.setCliProvider(new WLSTExecutorProvider<Set>(shell, Set.class));
            command.addArg(Main.gridwidth);
            command.addHelp();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("connect");
            command.setDescription("Goes online.\nE.g) " + command.getCommandName());
            command.setCliProvider(new WLSTExecutorProvider<WLSTConnect>(shell, WLSTConnect.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            command = new CommandLine();
            command.setCommandName("disconnect");
            command.setDescription("Goes Offline.\nE.g) " + command.getCommandName());
            command.setCliProvider(new WLSTExecutorProvider<WLSTDisconnect>(shell, WLSTDisconnect.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            command = new CommandLine();
            command.setCommandName("list-applications");
            command.setDescription("Lists all the deployed applications.\nE.g) " + command.getCommandName());
            command.setCliProvider(new WLSTExecutorProvider<ListApplications>(shell, ListApplications.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("restart-application");
            command.setDescription("Restarts an application\nE.g) " + command.getCommandName() + " -" + "application" + " myapp");
            command.setCliProvider(new WLSTExecutorProvider<RestartApplication>(shell, RestartApplication.class));
            command.addArg(Main.appName);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("list-all-webservice-policies");
            command.setDescription("Lists all the available webservice policies.\nE.g) " + command.getCommandName() + ";" + command.getCommandName() + "-" + "subject" + " client");
            command.setCliProvider(new WLSTExecutorProvider<ListAvailablePolicies>(shell, ListAvailablePolicies.class));
            command.addArg(category);
            command.addArg(target);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("list-webservices");
            command.setDescription("Lists all the web services.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp -" + "verbose");
            command.setCliProvider(new WLSTExecutorProvider<ListServices>(shell, ListServices.class));
            command.addArg(Main.appName);
            command.addArg(Main.fullFormat);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("attach-webservice-policy");
            command.setDescription("Attaches service policies to a web service endpoint.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "service" + " {http://sample.test.ws/}MyTestService -" + "subject" + " mytestport -" + "policyuri" + " oracle/wss_saml_or_username_token_service_policy");
            command.setCliProvider(new WLSTExecutorProvider<AttachServicePolicy>(shell, AttachServicePolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(service);
            command.addArg(subject);
            command.addArg(policyuris);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("detach-webservice-policy");
            command.setDescription("Detaches service policies from a web service endpoint.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "service" + " {http://sample.test.ws/}MyTestService -" + "subject" + " mytestport -" + "policyuri" + " oracle/wss_saml_or_username_token_service_policy");
            command.setCliProvider(new WLSTExecutorProvider<DetachServicePolicy>(shell, DetachServicePolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(service);
            command.addArg(subject);
            command.addArg(policyuris);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("enable-webservice-policy");
            command.setDescription("Enables  already attached policies at a web service endpoint.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "service" + " {http://sample.test.ws/}MyTestService -" + "subject" + " mytestport -" + "policyuri" + " oracle/wss_saml_or_username_token_service_policy");
            command.setCliProvider(new WLSTExecutorProvider<EnableServicePolicy>(shell, EnableServicePolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(service);
            command.addArg(subject);
            command.addArg(policyuris);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("disable-webservice-policy");
            command.setDescription("Disables  active policies at a web service endpoint.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "service" + " {http://sample.test.ws/}MyTestService -" + "subject" + " mytestport -" + "policyuri" + " oracle/wss_saml_or_username_token_service_policy");
            command.setCliProvider(new WLSTExecutorProvider<DisableServicePolicy>(shell, DisableServicePolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(service);
            command.addArg(subject);
            command.addArg(policyuris);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("set-webservice-config");
            command.setDescription("Sets web services configuration.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "service" + " {http://sample.test.ws/}MyTestService -" + "subject" + " mytestport -" + "configprops" + " enable=true,enableTestPage=true,enableWSDL=false");
            command.setCliProvider(new WLSTExecutorProvider<SetServiceConfiguration>(shell, SetServiceConfiguration.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(service);
            command.addArg(subject);
            command.addArg(props);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("set-webservice-policy-override");
            command.setDescription("Sets web service policy overrides.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "service" + " {http://sample.test.ws/}MyTestService -" + "subject" + " mytestport -" + "policyuri" + " oracle/wss10_message_protection_service_policy -" + "overrideprops" + " keystore.sig.csf.key=sign-csf-key");
            command.setCliProvider(new WLSTExecutorProvider<SetServicePolicyOverride>(shell, SetServicePolicyOverride.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(service);
            command.addArg(subject);
            command.addArg(policyuri);
            command.addArg(overrideprops);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("list-webservice-clients");
            command.setDescription("Lists all the web service clients.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp;" + command.getCommandName() + " -" + "application" + " myapp -" + "verbose");
            command.setCliProvider(new WLSTExecutorProvider<ListClients>(shell, ListClients.class));
            command.addArg(Main.appName);
            command.addArg(Main.fullFormat);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("attach-webservice-client-policy");
            command.setDescription("Attaches client policies to a web service client.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "clienttype" + " wsconn -" + "serviceref" + " myserviceref -" + "port" + " serviceport -" + "policyuri" + " oracle/wss_saml_token_bearer_over_ssl_client_policy");
            command.setCliProvider(new WLSTExecutorProvider<AttachClientPolicy>(shell, AttachClientPolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(clienttype);
            command.addArg(serviceref);
            command.addArg(port);
            command.addArg(policyuris);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("detach-webservice-client-policy");
            command.setDescription("Detaches client policies to a web service client.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "clienttype" + " wsconn -" + "serviceref" + " myserviceref -" + "port" + " serviceport -" + "policyuri" + " oracle/wss_saml_token_bearer_over_ssl_client_policy");
            command.setCliProvider(new WLSTExecutorProvider<DetachClientPolicy>(shell, DetachClientPolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(clienttype);
            command.addArg(serviceref);
            command.addArg(port);
            command.addArg(policyuris);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("enable-webservice-client-policy");
            command.setDescription("Enables client policies to a web service client.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "clienttype" + " wsconn -" + "serviceref" + " myserviceref -" + "port" + " serviceport -" + "policyuri" + " oracle/wss_saml_token_bearer_over_ssl_client_policy");
            command.setCliProvider(new WLSTExecutorProvider<EnableClientPolicy>(shell, EnableClientPolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(clienttype);
            command.addArg(serviceref);
            command.addArg(port);
            command.addArg(policyuris);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("disable-webservice-client-policy");
            command.setDescription("Detaches client policies to a web service client.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "clienttype" + " wsconn -" + "serviceref" + " myserviceref -" + "port" + " serviceport -" + "policyuri" + " oracle/wss_saml_token_bearer_over_ssl_client_policy");
            command.setCliProvider(new WLSTExecutorProvider<DisableClientPolicy>(shell, DisableClientPolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(clienttype);
            command.addArg(serviceref);
            command.addArg(port);
            command.addArg(policyuris);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("list-webservice-client-properties");
            command.setDescription("Lists client stub properties to a web service client.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "clienttype" + " wsconn -" + "serviceref" + " myserviceref -" + "port" + " serviceport");
            command.setCliProvider(new WLSTExecutorProvider<DisableClientPolicy>(shell, DisableClientPolicy.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(clienttype);
            command.addArg(serviceref);
            command.addArg(port);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("set-webservice-client-property");
            command.setDescription("Sets web service client stub properties to a web service client.\nE.g) " + command.getCommandName() + " -" + "application" + " myapp" + " -" + "module" + " myweb -" + "clienttype" + " wsconn -" + "serviceref" + " myserviceref -" + "port" + " serviceport");
            command.setCliProvider(new WLSTExecutorProvider<SetClientStubProperty>(shell, SetClientStubProperty.class));
            command.addArg(Main.appName);
            command.addArg(module);
            command.addArg(clienttype);
            command.addArg(serviceref);
            command.addArg(port);
            command.addArg(stubprops);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("list-token-issuer-trust");
            command.setDescription("Displays SAML token trust.\nE.g) " + command.getCommandName() + " -" + "tokentype" + " dns.hok");
            command.setCliProvider(new WLSTExecutorProvider<DisplaySAMLTrust>(shell, DisplaySAMLTrust.class));
            command.addArg(issuer);
            command.addArg(token);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("set-token-issuer-trust");
            command.setDescription("Sets SAML token trust.\nE.g) " + command.getCommandName() + " -" + "tokentype" + " dns.hok");
            command.setCliProvider(new WLSTExecutorProvider<SetSAMLTrust>(shell, SetSAMLTrust.class));
            command.addArg(issuer);
            command.addArg(token);
            command.addArg(alias);
            command.addArg(dns);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("list-wss-certificates");
            command.setDescription("Lists WSS certificates.\nE.g) " + command.getCommandName());
            command.setCliProvider(new WLSTExecutorProvider<ListWSSCertificates>(shell, ListWSSCertificates.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("delete-token-issuer-trust");
            command.setDescription("Deletes SAML token trust.\nE.g) " + command.getCommandName() + " -" + "tokentype" + " dns.hok");
            command.setCliProvider(new WLSTExecutorProvider<DisplaySAMLTrust>(shell, DisplaySAMLTrust.class));
            command.addArg(issuer);
            command.addArg(token);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("usage");
            command.setCliProvider(new CliExecutorProvider<HtmlUsagePageGenerator>(HtmlUsagePageGenerator.class, MainBase.class, main));
            command.setDescription(NLSUtil.localizeMessage("COMMAND_DESCR_USAGE", HtmlUsagePageGenerator.FILE_NAME));
            command.addArg(new CommandLineArg("output", false, (CommandLineArg.OptionType)new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, true, true), NLSUtil.localizeMessage("PARAM_DESCR_OUTPUT"), NLSUtil.localizeMessage("PARAM_MSG_OUTDIR")));
            CommandLineArg xml = new CommandLineArg("xml", false, new CommandLineArg.BooleanOptionType(), "When true, the help is printed as an xml document.");
            xml.setOptionDefaltValue("false");
            xml.setShortCut("x");
            xml.setHidden(true);
            command.addArg(xml);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("exit");
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Exits from this shell.");
            command.setCliProvider(new WLSTExecutorProvider<Exit>(shell, Exit.class));
            command.addArg(retain);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("hist");
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Displays history of commands. It can also execute a command from the history.\nE.g) " + command.getCommandName() + ";" + command.getCommandName() + " id");
            command.setCliProvider(new WLSTExecutorProvider<History>(shell, History.class));
            command.addArg(dump);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            WLSTMain.addCommandLine(command);
            return main;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public String getUsage(boolean html) {
        String command1 = "list-webservice-clients -application myapp -verbose";
        String command2 = "set application=myapplication \"service=Service with space\"";
        String command3 = "set-webservice-client-property -help";
        String note = NLSUtil.localizeMessage("NLS_FS_USAGE_NOTE");
        if (html) {
            command1 = CloudUtil.textEncodetoXML(command1, true);
            command2 = CloudUtil.textEncodetoXML(command2, true);
            command3 = CloudUtil.textEncodetoXML(command3, true);
        }
        String usage = "command [-help] [-args] [input values] [;nextcommand]\n\n";
        return (html ? CloudUtil.convertToHelpText(usage, 80, 5) : note) + (html ? CloudUtil.convertToHelpText(note, 80, 5) : note) + "\n\n\nFor example:\n" + "     1.)" + (html ? CloudUtil.convertToHelpText(command1, html ? 160 : 80, 10) : command1) + "\n\n     2.)" + (html ? CloudUtil.convertToHelpText(command2, html ? 160 : 80, 10) : command2) + "\n\n     3.)" + (html ? CloudUtil.convertToHelpText(command3, html ? 160 : 80, 10) : command3);
    }

    public static void addCommandLine(CommandLine command) {
        allCommands.put(command.getCommandName(), command);
    }

    @Override
    public Properties getDefaultProperties(CommandLine cmd) {
        return this.properties;
    }
}

