/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.wlst;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.common.wlst.WLSTShell;
import oracle.cloud.paas.client.cli.command.common.wlst.cmd.AbstractWLSTCommand;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.CommandType;

public class Set
extends AbstractWLSTCommand {
    protected int gridWidth = 180;

    public Set(WLSTShell fs) {
        super(fs);
    }

    @Override
    public void validate() throws CliException {
        super.validate();
        String gw = this.command.getArgValue("gridwidth");
        if (gw != null) {
            try {
                this.gridWidth = Integer.parseInt(gw);
                if (this.gridWidth < 0) {
                    throw new NumberFormatException("gridwidth must be a positive integer");
                }
            }
            catch (NumberFormatException e) {
                throw new CliException("Please enter valid value for gridwidth", e);
            }
        }
    }

    @Override
    public void execute() throws Exception {
        if (this.command.getExtraArgs().isEmpty()) {
            OrderedMap<String, List<CommandLine>> map = this.shell.getMain().getOptionsMap();
            Grid grid = new Grid();
            grid.addColumn("argument");
            grid.addColumn("value");
            ArrayList<String> unsetProps = new ArrayList<String>();
            Properties prop = this.shell.getMain().getDefaultProperties(this.command);
            for (String key : map.keySet()) {
                if (!prop.containsKey(key)) {
                    unsetProps.add(key);
                    continue;
                }
                int col = 0;
                Row r = grid.createNewRow();
                r.setObjectAt(key, col++);
                r.setObjectAt(prop.get(key), col++);
            }
            int col = 0;
            Row r = grid.createNewRow();
            r.setObjectAt(CloudUtil.getSeparatedListOfString(unsetProps, "[", "]", false, ", "), col++);
            r.setObjectAt("--NOT SET--", col++, true);
            BeanUtils.printGridRecursive(grid, "argument(s) and their values.", this.gridWidth, true);
        } else {
            OrderedMap<String, List<CommandLine>> map = this.shell.getMain().getOptionsMap();
            Properties prop = this.shell.getMain().getDefaultProperties(this.command);
            for (String line : this.command.getExtraArgs()) {
                int index = line.indexOf("=");
                if ((line = line.trim()).equals("")) continue;
                if (index < 0) {
                    if (prop.containsKey(line)) {
                        prop.remove(line);
                        Logger.getDEFAULT().println("Removed:" + line);
                        continue;
                    }
                    throw new Exception("Argument not found:" + line);
                }
                String key = line.substring(0, index);
                if (map.containsKey(key)) {
                    Logger.getDEFAULT().println("Added:" + key);
                    prop.put(key, line.substring(index + 1, line.length()));
                    continue;
                }
                throw new Exception("Argument not found:" + key);
            }
        }
        this.shell.getWLST().executeWLSTCommand(new CommandType());
    }
}

