/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.owsm.trust;

import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.api.service.resource.KeyStoreManagerService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ResetStore
extends CommonBaseExecutor {
    private String stripeName;
    private String keystoreName;

    @Override
    public void validate() throws CliException {
        super.validate();
        this.stripeName = this.command.getArgValue("stripe");
        this.keystoreName = this.command.getArgValue("keystore");
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        KeyStoreManagerService res = (KeyStoreManagerService)client.getService(KeyStoreManagerService.class);
        CertificateService c = null;
        c = this.stripeName != null && this.keystoreName != null ? res.getTrustService(this.stripeName, this.keystoreName) : res.getDomainLevelTrustService();
        c.resetCertificateStore();
        Logger.getDEFAULT().printlnInfoI18n("NLS_INFO_CERT_STORE_RESET", "WSS");
    }

    public Class<? extends Service> getServiceClass() {
        return CertificateService.class;
    }
}

