/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.fs.cmd;

import java.io.File;
import java.io.InputStream;
import oracle.cloud.paas.client.cli.command.common.fs.FSBaseCommandExecutor;
import oracle.cloud.paas.client.cli.command.common.fs.FSShell;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ZGet
extends FSBaseCommandExecutor {
    boolean force = false;

    public ZGet(FSShell fs) {
        super(fs);
    }

    @Override
    public void validate() throws CliException {
        super.validate();
        this.force = this.command.getValueAsBoolean("force");
    }

    @Override
    public void execute0() throws Exception {
        if (this.command.getExtraArgs().isEmpty()) {
            this.command.getExtraArgs().add(this.fs.pwd());
        }
        for (String d : this.command.getExtraArgs()) {
            String localZip;
            String dir = new File(d).getName();
            if (!dir.equals("")) {
                dir = "_" + dir;
            }
            if (this.isLocalDir(new File(localZip = "remote" + dir + ".zip").getName())) {
                throw new Exception("Local path \"" + new File(localZip).getName() + "\" is not a file.");
            }
            if (this.existLocal(localZip) && !this.force) {
                throw new Exception("Local file \"" + new File(localZip).getName() + "\" exists, Please force the operation to overwrite.");
            }
            InputStream in = this.fs.readAsZip(d);
            this.shell.getLocalfs().write(new File(localZip).getName(), in, this.force);
            Logger.getDEFAULT().printlnInfo("Downloaded:" + localZip);
        }
    }
}

