/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.fs.cmd;

import java.util.Date;
import java.util.List;
import oracle.cloud.paas.client.cli.bean.BeanUtils;
import oracle.cloud.paas.client.cli.command.common.CommonBeanUtil;
import oracle.cloud.paas.client.cli.command.common.fs.FSLocalRunnableCommand;
import oracle.cloud.paas.client.cli.command.common.fs.FSShell;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.TimeUtils;
import oracle.cloudlogic.javaservice.types.FilePathType;
import oracle.cloudlogic.javaservice.types.PathType;

public class Ls
extends FSLocalRunnableCommand {
    boolean verbose = false;

    public Ls(FSShell fs) {
        super(fs);
    }

    @Override
    public void validate() throws CliException {
        super.validate();
        this.verbose = this.command.getValueAsBoolean("verbose");
    }

    @Override
    public void execute0() throws Exception {
        if (!this.command.getExtraArgs().isEmpty()) {
            for (String path : this.command.getExtraArgs()) {
                this.print(path);
            }
        } else {
            this.print(null);
        }
    }

    private void print(String path) throws Exception {
        List list = null;
        boolean isFile = false;
        if (path == null) {
            list = this.fs.list();
            path = "";
        } else {
            list = this.fs.list(path);
            if (list.size() == 1) {
                isFile = this.isFile(path);
            }
        }
        if (!list.isEmpty()) {
            Grid g = new Grid();
            g.addColumn("#");
            g.addColumn("Name");
            g.addColumn("Dir");
            g.addColumn("File Type");
            g.addColumn("Last Modified Description");
            if (this.verbose) {
                g.addColumn("Last Modified");
                g.addColumn("size");
            }
            int count = 1;
            for (PathType p : list) {
                int col = 0;
                Row r = g.createNewRow();
                r.setObjectAt(count++, col++);
                r.setObjectAt(p.getPath(), col++);
                if (FilePathType.class.isAssignableFrom(p.getClass())) {
                    r.setObjectAt("", col++);
                    FilePathType f = (FilePathType)p;
                    r.setObjectAt(f.getMimeType(), col++);
                    r.setObjectAt(f.getModifiedOn() == null ? "" : TimeUtils.millisToLongDHMS(new Date().getTime() - f.getModifiedOn().getTime(), false), col++);
                    if (!this.verbose) continue;
                    r.setObjectAt(f.getModifiedOn(), col++);
                    r.setObjectAt(f.getInteger(), col++);
                    continue;
                }
                r.setObjectAt("d", col++);
            }
            if (this.shell.isGrid()) {
                BeanUtils.printGridRecursive(g, (isFile ? "" : "file(s) under ") + this.fs.describe(path).getPath(), this.shell.getGridWidth(), !isFile);
            } else {
                CommonBeanUtil.printGridAsList(g, (isFile ? "" : "file(s) under ") + this.fs.describe(path).getPath(), !isFile);
            }
        }
    }
}

