/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.fs;

import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloud.paas.client.cli.command.HtmlUsagePageGenerator;
import oracle.cloud.paas.client.cli.command.common.fs.Exit;
import oracle.cloud.paas.client.cli.command.common.fs.FSExecutorProvider;
import oracle.cloud.paas.client.cli.command.common.fs.FSShell;
import oracle.cloud.paas.client.cli.command.common.fs.History;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Cat;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Cd;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Copy;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Echo;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Get;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Ls;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Mkdir;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Put;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Pwd;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Rename;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Rm;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Touch;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.Who;
import oracle.cloud.paas.client.cli.command.common.fs.cmd.ZGet;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.provider.CliExecutorProvider;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;

public class FSMain
extends MainBase
implements ClientConstants {
    public static final OrderedMap<String, CommandLine> allCommands = new OrderedMap();

    public FSMain(String defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    @Override
    public OrderedMap<String, CommandLine> getAllCommands() {
        return allCommands;
    }

    public static FSMain createWith(FSShell shell) throws Exception {
        try {
            CommandLineArg force = new CommandLineArg("force", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_FORCE"));
            CommandLineArg recursive = new CommandLineArg("recursive", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_RECURSIVE"));
            CommandLineArg local = Main.ARG_LOCAL.simpleClone();
            local.setDescription("When true, the shell performs the command against local file system.");
            FSMain main = new FSMain(null);
            main.setTEST_MODE(true);
            CommandLine command = new CommandLine();
            command.setCommandName("pwd");
            command.setDescription("Prints current working directory.\nE.g) " + command.getCommandName() + ";" + command.getCommandName() + " -" + "local");
            command.setCliProvider(new FSExecutorProvider<Pwd>(shell, Pwd.class));
            command.addArg(local);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("ls");
            command.addCommandAlias("dir");
            command.setDescription("Lists all the files and directories from given set of path(s).\nE.g) " + command.getCommandName() + " dir1 dir2;" + command.getCommandName() + " -" + "local");
            command.setCliProvider(new FSExecutorProvider<Ls>(shell, Ls.class));
            command.addArg(Main.fullFormat);
            command.addArg(local);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("cd");
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Changes the current directory to an existing directory.When executed without an argument, it changes to the last known directory.\nE.g) " + command.getCommandName() + " dir");
            command.setCliProvider(new FSExecutorProvider<Cd>(shell, Cd.class));
            command.addArg(local);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("mkdir");
            command.addCommandAlias("md");
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Creates new directory.\nE.g) " + command.getCommandName() + " newdir");
            command.setCliProvider(new FSExecutorProvider<Mkdir>(shell, Mkdir.class));
            command.addArg(local);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("rm");
            command.addCommandAlias("del");
            command.addArg(local);
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Deletes an existing directory or a file.\nE.g) " + command.getCommandName() + " dir");
            command.setCliProvider(new FSExecutorProvider<Rm>(shell, Rm.class));
            command.addArg(force);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("cat");
            command.addCommandAlias("type");
            command.addArg(local);
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Prints a file.\nE.g) " + command.getCommandName() + " file");
            command.setCliProvider(new FSExecutorProvider<Cat>(shell, Cat.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("echo");
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Echos the given text .\nE.g) " + command.getCommandName() + " text");
            command.setCliProvider(new FSExecutorProvider<Echo>(shell, Echo.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("who");
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Prints the user name that has logged on.\nE.g) " + command.getCommandName());
            command.setCliProvider(new FSExecutorProvider<Who>(shell, Who.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("touch");
            command.addArg(local);
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Creates an empty file if that does not exist.\nE.g) " + command.getCommandName() + " newfile");
            command.setCliProvider(new FSExecutorProvider<Touch>(shell, Touch.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("cp");
            command.addCommandAlias("copy");
            command.addArg(recursive);
            command.addArg(local);
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Copies a file to another location.\nE.g) " + command.getCommandName() + " source dest");
            command.setCliProvider(new FSExecutorProvider<Copy>(shell, Copy.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("mv");
            command.addCommandAlias("move");
            command.addArg(force);
            command.addArg(local);
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Moves a file to another location.\nE.g) " + command.getCommandName() + " source dest");
            command.setCliProvider(new FSExecutorProvider<Rename>(shell, Rename.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("get");
            command.addCommandAlias("download");
            command.addArg(force);
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Gets(download) a remote file to the current local directory.\nE.g) " + command.getCommandName() + " remotepath");
            command.setCliProvider(new FSExecutorProvider<Get>(shell, Get.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("zget");
            command.addArg(force);
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Gets(download) a remote dir as a zip file to the current local directory.\nE.g) " + command.getCommandName() + ";" + command.getCommandName() + " remotedir");
            command.setCliProvider(new FSExecutorProvider<ZGet>(shell, ZGet.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("put");
            command.addCommandAlias("upload");
            command.addArg(force);
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Puts(upload) a local file to the current remote directory.\nE.g) " + command.getCommandName() + " localpath");
            command.setCliProvider(new FSExecutorProvider<Put>(shell, Put.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("usage");
            command.setCliProvider(new CliExecutorProvider<HtmlUsagePageGenerator>(HtmlUsagePageGenerator.class, MainBase.class, main));
            command.setDescription(NLSUtil.localizeMessage("COMMAND_DESCR_USAGE", HtmlUsagePageGenerator.FILE_NAME));
            command.addArg(new CommandLineArg("output", false, (CommandLineArg.OptionType)new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, true, true), NLSUtil.localizeMessage("PARAM_DESCR_OUTPUT"), NLSUtil.localizeMessage("PARAM_MSG_OUTDIR")));
            CommandLineArg xml = new CommandLineArg("xml", false, new CommandLineArg.BooleanOptionType(), "When true, the help is printed as an xml document.");
            xml.setOptionDefaltValue("false");
            xml.setShortCut("x");
            xml.setHidden(true);
            command.addArg(xml);
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("exit");
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Exits from this shell.");
            command.setCliProvider(new FSExecutorProvider<Exit>(shell, Exit.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            command = new CommandLine();
            command.setCommandName("hist");
            command.setExtraArgsType(new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null));
            command.setDescription("Displays history of commands. It can also execute a command from the history.\nE.g) " + command.getCommandName() + ";" + command.getCommandName() + " id");
            command.setCliProvider(new FSExecutorProvider<History>(shell, History.class));
            command.addHelp();
            command.addDebugArgs();
            command.updateShortCut();
            FSMain.addCommandLine(command);
            return main;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public String getUsage(boolean html) {
        String command1 = "ls path1 path2";
        String command2 = "cd dir;ls;cd ..";
        String command3 = "get -help";
        String note = NLSUtil.localizeMessage("NLS_FS_USAGE_NOTE");
        if (html) {
            command1 = CloudUtil.textEncodetoXML(command1, true);
            command2 = CloudUtil.textEncodetoXML(command2, true);
            command3 = CloudUtil.textEncodetoXML(command3, true);
        }
        String usage = "command [-help] [-args] [input values] [;nextcommand]\n\n";
        return (html ? CloudUtil.convertToHelpText(usage, 80, 5) : note) + (html ? CloudUtil.convertToHelpText(note, 80, 5) : note) + "\n\n\nFor example:\n" + "     1.)" + (html ? CloudUtil.convertToHelpText(command1, html ? 160 : 80, 10) : command1) + "\n\n     2.)" + (html ? CloudUtil.convertToHelpText(command2, html ? 160 : 80, 10) : command2) + "\n\n     3.)" + (html ? CloudUtil.convertToHelpText(command3, html ? 160 : 80, 10) : command3);
    }

    public static void addCommandLine(CommandLine command) {
        allCommands.put(command.getCommandName(), command);
    }
}

