/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.dsjndi;

import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloud.paas.model.ServiceType;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.service.ResourceManagerService;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.DataSourceJndiService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.executor.ConfirmableExecutor;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.AssociationType;
import oracle.cloudlogic.javaservice.types.UserInstanceType;

public class DeleteDSJndiName
extends CommonBaseExecutor
implements ConfirmableExecutor {
    private String ds;
    private String jndiAlias;

    @Override
    public void validate() throws CliException {
        super.validate();
        this.ds = this.command.getArgValue("datasource");
        this.jndiAlias = this.command.getArgValue("jndiname");
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        ResourceManagerService r = (ResourceManagerService)client.getService(ResourceManagerService.class);
        if (this.ds == null) {
            UserInstanceType instance = r.describeService();
            for (AssociationType at : instance.getAssociation()) {
                if (!ServiceType.DATABASE.toString().equals(at.getType())) continue;
                this.ds = at.getName();
                break;
            }
            if (this.ds == null) {
                throw new Exception("No data source found;");
            }
        }
        DataSourceJndiService d = (DataSourceJndiService)r.getResourceService(DataSourceJndiService.class);
        d.deleteJndiName(this.ds, this.jndiAlias);
        Logger.getDEFAULT().printlnI18n("NLS_INFO_DELETE_JNDI_NAME_OK", new Object[]{this.jndiAlias, this.ds});
    }

    public Class<? extends Service> getServiceClass() {
        return DataSourceJndiService.class;
    }

    @Override
    public String getForceArgumentName() {
        return "force";
    }

    @Override
    public String getConfirmMessage() {
        if (this.ds == null) {
            return NLSUtil.localizeMessage("NLS_CONFIRM_DELETION_JNDI_ALIAS", new Object[]{this.jndiAlias, new String("Default Datasource")});
        }
        return NLSUtil.localizeMessage("NLS_CONFIRM_DELETION_JNDI_ALIAS", new Object[]{this.jndiAlias, this.ds});
    }
}

