/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.cred;

import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.service.ResourceManagerService;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.CredentialService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.CredentialType;
import oracle.cloudlogic.javaservice.types.Password;

public class SetCredential
extends CommonBaseExecutor {
    private String map = null;
    private String key = null;
    private String keyuser = null;
    private String keypwd = null;
    private String description = null;

    @Override
    public void validate() throws CliException {
        super.validate();
        this.map = this.command.getArgValue("map");
        this.key = this.command.getArgValue("key");
        this.keyuser = this.command.getArgValue("keyuser");
        this.keypwd = this.command.getArgValue("keypassword");
        this.description = this.command.getArgValue("description");
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        ResourceManagerService r = (ResourceManagerService)client.getService(ResourceManagerService.class);
        CredentialService c = (CredentialService)r.getResourceService(CredentialService.class);
        CredentialType t = new CredentialType();
        t.setKey(this.key);
        t.setUser(this.keyuser);
        t.setDescription(this.description);
        t.setPassword(new Password());
        t.getPassword().setValue(this.keypwd.getBytes("UTF-8"));
        t.getPassword().setEncrypted(Boolean.FALSE);
        if (c.setCredential(this.map, t)) {
            Logger.getDEFAULT().printlnInfo("Update - OK");
        } else {
            Logger.getDEFAULT().printlnInfo("Create - OK");
        }
    }

    public Class<? extends Service> getServiceClass() {
        return CredentialService.class;
    }
}

