/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.cli.command.common.certficate;

import java.util.List;
import oracle.cloud.paas.client.cli.command.common.CommonBaseExecutor;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class CommonDeleteCertificates
extends CommonBaseExecutor {
    private List<String> aliases;

    @Override
    public void validate() throws CliException {
        super.validate();
        String alias = this.command.getArgValue("alias");
        if (alias != null) {
            alias = CloudUtil.parseAndRemoveDuplicates(alias, ",");
            this.aliases = CloudUtil.parseString(alias, ",", true);
        }
        if (this.aliases == null || this.aliases.isEmpty()) {
            throw new CliException("Missing alias.");
        }
    }

    @Override
    public void invoke(ServiceManager client) throws Exception {
        throw new RuntimeException("Not to be called ...");
    }

    public void invoke(CertificateService c) throws Exception {
        int count = 0;
        for (String alias : this.aliases) {
            try {
                c.deleteCertificate(alias);
                Logger.getDEFAULT().printlnInfo("Alias " + alias + " deleted.");
                ++count;
            }
            catch (UnknownResourceException un) {
                Logger.getDEFAULT().printlnWarning("Alias " + alias + " did not exist.");
            }
            catch (Exception e) {
                Logger.getDEFAULT().printlnWarning("Alias " + alias + " could not be deleted." + e.getMessage());
            }
        }
        if (count == 0) {
            throw new Exception("No certificates deleted.");
        }
    }

    public Class<? extends Service> getServiceClass() {
        throw new RuntimeException("Not to be called ...");
    }
}

